/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck.tests.forms;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.annotation.RequestFilter;
import io.micronaut.http.annotation.ServerFilter;
import io.micronaut.http.annotation.Status;
import io.micronaut.http.server.filter.FilterBodyParser;
import io.micronaut.http.tck.AssertionUtils;
import io.micronaut.http.tck.HttpResponseAssertion;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.http.tck.TestScenario;
import io.micronaut.scheduling.annotation.ExecuteOn;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.junit.jupiter.api.Test;

public class FormUrlEncodedBodyInRequestFilterTest {
    public static final String SPEC_NAME = "FormUrlEncodedBodyInRequestFilterTest";

    @Test
    public void bodyParsingInFilter() throws IOException {
        String csrfToken = "abcde";
        Object body = "username=sherlock&csrfToken=" + csrfToken + "&password=elementary";
        this.assertOk(body, MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        PasswordChangeForm json = new PasswordChangeForm("sherlock", "elementary", null);
        this.assertUnauthorized(json, MediaType.APPLICATION_JSON_TYPE);
        json = new PasswordChangeForm("sherlock", "elementary", csrfToken);
        this.assertOk(json, MediaType.APPLICATION_JSON_TYPE);
        body = "username=sherlock&password=elementary";
        this.assertUnauthorized(body, MediaType.APPLICATION_FORM_URLENCODED_TYPE);
    }

    void assertOk(Object body, MediaType contentType) throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.POST((String)"/password/change", (Object)body).contentType(contentType)).assertion((server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.ACCEPTED).build())).run();
    }

    void assertUnauthorized(Object body, MediaType contentType) throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.POST((String)"/password/change", (Object)body).contentType(contentType)).assertion((server, request) -> AssertionUtils.assertThrows((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.UNAUTHORIZED).build())).run();
    }

    @Introspected
    record PasswordChangeForm(String username, String password, String csrfToken) {
    }

    @Introspected
    record PasswordChange(String username, String password) {
    }

    @Requires(property="spec.name", value="FormUrlEncodedBodyInRequestFilterTest")
    @ServerFilter(value={"/**"})
    static class CsrfFilter {
        private final FilterBodyParser bodyParser;

        CsrfFilter(FilterBodyParser bodyParser) {
            this.bodyParser = bodyParser;
        }

        @ExecuteOn(value="blocking")
        @RequestFilter
        @Nullable
        public HttpResponse<?> csrfFilter(@NonNull HttpRequest<?> request) {
            Map body = null;
            try {
                body = (Map)this.bodyParser.parseBody(request).get();
            }
            catch (InterruptedException e) {
                return HttpResponse.unauthorized();
            }
            catch (ExecutionException e) {
                return HttpResponse.unauthorized();
            }
            return body.containsKey("csrfToken") && body.get("csrfToken").equals("abcde") ? null : HttpResponse.unauthorized();
        }
    }

    @Requires(property="spec.name", value="FormUrlEncodedBodyInRequestFilterTest")
    @Controller
    static class PasswordChangeController {
        PasswordChangeController() {
        }

        @Produces(value={"text/html"})
        @Consumes(value={"application/x-www-form-urlencoded"})
        @Post(value="/password/change")
        @Status(value=HttpStatus.ACCEPTED)
        void changePasswordForm(@Body PasswordChange passwordChangeForm) {
        }

        @Produces(value={"text/html"})
        @Post(value="/password/change")
        @Status(value=HttpStatus.ACCEPTED)
        void changePasswordJson(@Body PasswordChange passwordChangeForm) {
        }
    }
}

