/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck.tests;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Delete;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.Status;
import io.micronaut.http.tck.AssertionUtils;
import io.micronaut.http.tck.HttpResponseAssertion;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.http.tck.TestScenario;
import jakarta.validation.ConstraintViolationException;
import java.io.IOException;
import java.util.Collections;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class ResponseStatusTest {
    public static final String SPEC_NAME = "ResponseStatusTest";

    @Test
    void testConstraintViolationCauses400() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.POST((String)"/response-status/constraint-violation", (Object)"").header((CharSequence)"Content-Type", (CharSequence)"text/plain"), (server, request) -> AssertionUtils.assertThrows((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.BAD_REQUEST).build()));
    }

    @Test
    void testVoidMethodsDoesNotCause404() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.DELETE((String)"/response-status/delete-something").header((CharSequence)"Content-Type", (CharSequence)"text/plain"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.NO_CONTENT).build()));
    }

    @Test
    void testNullCauses404() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.GET((String)"/response-status/null").header((CharSequence)"Content-Type", (CharSequence)"text/plain"), (server, request) -> AssertionUtils.assertThrows((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.NOT_FOUND).build()));
    }

    @Test
    void testOptionalCauses404() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.GET((String)"/response-status/optional").header((CharSequence)"Content-Type", (CharSequence)"text/plain"), (server, request) -> AssertionUtils.assertThrows((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.NOT_FOUND).build()));
    }

    @Test
    void testCustomResponseStatus() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.POST((String)"/response-status", (Object)"foo").header((CharSequence)"Content-Type", (CharSequence)"text/plain"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.CREATED).body("foo").build()));
    }

    @Controller(value="/response-status")
    @Requires(property="spec.name", value="ResponseStatusTest")
    static class StatusController {
        StatusController() {
        }

        @Post(uri="/", processes={"text/plain"})
        @Status(value=HttpStatus.CREATED)
        String post(@Body String data) {
            return data;
        }

        @Get(uri="/optional", processes={"text/plain"})
        Optional<String> optional() {
            return Optional.empty();
        }

        @Get(uri="/null", processes={"text/plain"})
        String returnNull() {
            return null;
        }

        @Post(uri="/constraint-violation", processes={"text/plain"})
        String constraintViolation() {
            throw new ConstraintViolationException("Failed", Collections.emptySet());
        }

        @Status(value=HttpStatus.NO_CONTENT)
        @Delete(uri="/delete-something", processes={"text/plain"})
        void deleteSomething() {
        }
    }
}

