/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck.tests;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.ServerHttpRequest;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.body.ByteBody;
import io.micronaut.http.tck.AssertionUtils;
import io.micronaut.http.tck.BodyAssertion;
import io.micronaut.http.tck.HttpResponseAssertion;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.http.tck.TestScenario;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.stream.IntStream;
import org.junit.jupiter.api.Test;

public class OctetTest {
    public static final String SPEC_NAME = "OctetTest";

    @Test
    void canReadOctetEncodedData() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.GET((String)"/octets"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body(BodyAssertion.builder().body(OctetController.BODY_BYTES).equals()).build()));
    }

    @Test
    void byteBody() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.GET((String)"/octets/byteBody"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body(BodyAssertion.builder().body(OctetController.BODY_BYTES).equals()).build()));
    }

    @Controller(value="/octets")
    @Requires(property="spec.name", value="OctetTest")
    static class OctetController {
        static final byte[] BODY_BYTES = IntStream.iterate(1, i -> i + 1).limit(256L).map(i -> (byte)i).collect(ByteArrayOutputStream::new, ByteArrayOutputStream::write, (a, b) -> a.write(b.toByteArray(), 0, b.size())).toByteArray();

        OctetController() {
        }

        @Get(produces={"application/octet-stream"})
        HttpResponse<byte[]> byteArray() {
            return HttpResponse.ok((Object)BODY_BYTES);
        }

        @Get(value="/byteBody", produces={"application/octet-stream"})
        ByteBody byteBody(ServerHttpRequest<?> request) {
            return request.byteBodyFactory().adapt((byte[])BODY_BYTES.clone());
        }
    }
}

