/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck.tests;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.server.exceptions.ErrorResponseProcessorExceptionHandler;
import io.micronaut.http.server.exceptions.NotFoundException;
import io.micronaut.http.server.exceptions.response.ErrorResponseProcessor;
import io.micronaut.http.tck.AssertionUtils;
import io.micronaut.http.tck.BodyAssertion;
import io.micronaut.http.tck.HttpResponseAssertion;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.http.tck.TestScenario;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class NotFoundExceptionHandlerTest {
    public static final String SPEC_NAME = "NotFoundExceptionHandlerTest";
    private static final String EXPECTED = "<!DOCTYPE html>\n<html>\n<head>\n<title>Not Found</title>\n</head>\n<body>\n<h1>Not Found</h1>\n</body>\n</html>";

    @Test
    void testCatchingRouteNotFoundExceptions() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.GET((String)"/blababalbabagbababababa"), (server, request) -> AssertionUtils.assertThrows((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.NOT_FOUND).body(BodyAssertion.builder().body(EXPECTED).equals()).headers(Map.of("Content-Type", "text/html")).build()));
    }

    @Requires(property="spec.name", value="NotFoundExceptionHandlerTest")
    @Singleton
    @Produces
    static class NotFoundExceptionHandler
    extends ErrorResponseProcessorExceptionHandler<NotFoundException> {
        protected NotFoundExceptionHandler(ErrorResponseProcessor<?> responseProcessor) {
            super(responseProcessor);
        }

        protected MutableHttpResponse<?> createResponse(NotFoundException exception) {
            return HttpResponse.notFound((Object)NotFoundExceptionHandlerTest.EXPECTED).contentType((CharSequence)"text/html");
        }

        public HttpResponse<?> handle(HttpRequest request, NotFoundException exception) {
            return this.createResponse(exception);
        }
    }
}

