/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck.tests;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.filter.HttpServerFilter;
import io.micronaut.http.filter.ServerFilterChain;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import io.micronaut.http.tck.AssertionUtils;
import io.micronaut.http.tck.HttpResponseAssertion;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.http.tck.ServerUnderTestProviderUtils;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;

public class FiltersTest {
    public static final String SPEC_NAME = "FiltersTest";
    public static final String PROP_MICRONAUT_SERVER_CORS_ENABLED = "micronaut.server.cors.enabled";

    @Test
    void testFiltersAreRunCorrectly() throws IOException {
        Map configuration = CollectionUtils.mapOf((Object[])new Object[]{PROP_MICRONAUT_SERVER_CORS_ENABLED, "true"});
        try (ServerUnderTest server = ServerUnderTestProviderUtils.getServerUnderTestProvider().getServer(SPEC_NAME, configuration);){
            MutableHttpRequest request = HttpRequest.GET((String)"/filter-test/ok");
            AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("OK").headers(Collections.singletonMap("X-Test-Filter", "true")).build());
        }
    }

    @Test
    void filtersAreAppliedOnNonMatchingMethodsCorsFilterWorks() throws IOException {
        Map configuration = CollectionUtils.mapOf((Object[])new Object[]{PROP_MICRONAUT_SERVER_CORS_ENABLED, "true"});
        try (ServerUnderTest server = ServerUnderTestProviderUtils.getServerUnderTestProvider().getServer(SPEC_NAME, configuration);){
            MutableHttpRequest request = HttpRequest.OPTIONS((String)"/filter-test/ok").header((CharSequence)"Origin", (CharSequence)"https://micronaut.io").header((CharSequence)"Access-Control-Request-Method", (CharSequence)"GET");
            AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).headers(Collections.singletonMap("Access-Control-Allow-Origin", "https://micronaut.io")).build());
        }
    }

    @Test
    void filtersAreAppliedOnNonMatchingMethodsCorsFilterDisableIfNotPreflight() throws IOException {
        Map configuration = CollectionUtils.mapOf((Object[])new Object[]{PROP_MICRONAUT_SERVER_CORS_ENABLED, "true"});
        try (ServerUnderTest server = ServerUnderTestProviderUtils.getServerUnderTestProvider().getServer(SPEC_NAME, configuration);){
            MutableHttpRequest request = HttpRequest.OPTIONS((String)"/filter-test/ok");
            AssertionUtils.assertThrows((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.METHOD_NOT_ALLOWED).build());
        }
    }

    @Test
    void testFiltersAreRunCorrectlyWithCustomExceptionHandler() throws IOException {
        Map configuration = CollectionUtils.mapOf((Object[])new Object[]{PROP_MICRONAUT_SERVER_CORS_ENABLED, "true"});
        try (ServerUnderTest server = ServerUnderTestProviderUtils.getServerUnderTestProvider().getServer(SPEC_NAME, configuration);){
            MutableHttpRequest request = HttpRequest.GET((String)"/filter-test/exception");
            AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("Exception Handled").headers(Collections.singletonMap("X-Test-Filter", "true")).build());
        }
    }

    @Produces
    @Singleton
    @Requires(property="spec.name", value="FiltersTest")
    static class CustomExceptionHandler
    implements ExceptionHandler<CustomException, HttpResponse<?>> {
        CustomExceptionHandler() {
        }

        public HttpResponse handle(HttpRequest request, CustomException exception) {
            return HttpResponse.ok((Object)"Exception Handled");
        }
    }

    static class CustomException
    extends RuntimeException {
        CustomException() {
        }
    }

    @Filter(value={"/filter-test/**"})
    @Requires(property="spec.name", value="FiltersTest")
    static class TestFilter
    implements HttpServerFilter {
        TestFilter() {
        }

        public Publisher<MutableHttpResponse<?>> doFilter(HttpRequest<?> request, ServerFilterChain chain) {
            return Publishers.map((Publisher)chain.proceed(request), httpResponse -> {
                httpResponse.getHeaders().add((CharSequence)"X-Test-Filter", (CharSequence)"true");
                return httpResponse;
            });
        }
    }

    @Controller(value="/filter-test")
    @Requires(property="spec.name", value="FiltersTest")
    static class TestController {
        TestController() {
        }

        @Get(value="/ok")
        String ok() {
            return "OK";
        }

        @Get(value="/exception")
        void exception() {
            throw new CustomException();
        }
    }
}

