/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck.tests;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.tck.AssertionUtils;
import io.micronaut.http.tck.HttpResponseAssertion;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.http.tck.TestScenario;
import java.io.IOException;
import org.junit.jupiter.api.Test;

public class ConsumesTest {
    public static final String SPEC_NAME = "ConsumesTest";

    @Test
    void testMultipleConsumesDefinition() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.POST((String)"/consumes-test", (Object)"{\"name\":\"Fred\"}").header((CharSequence)"Content-Type", (CharSequence)"application/json"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("{\"name\":\"Fred\"}").build()));
    }

    @Test
    void testTextJson() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.POST((String)"/consumes-test/text-json", (Object)"{\"name\":\"Fred\"}").header((CharSequence)"Content-Type", (CharSequence)"text/json"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("{\"name\":\"Fred\"}").build()));
    }

    @Introspected
    static class Pojo {
        private String name;

        Pojo() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    @Controller(value="/consumes-test")
    @Requires(property="spec.name", value="ConsumesTest")
    static class ConsumesController {
        ConsumesController() {
        }

        @Post(value="/")
        @Consumes(value={"application/x-www-form-urlencoded", "application/json"})
        Pojo save(@Body Pojo pojo) {
            return pojo;
        }

        @Post(value="/text-json")
        @Consumes(value={"text/json"})
        Pojo textJson(@Body Pojo pojo) {
            return pojo;
        }
    }
}

