/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.handler.accesslog.element;

import io.micronaut.http.server.netty.handler.accesslog.element.AbstractHttpMessageLogElement;
import io.micronaut.http.server.netty.handler.accesslog.element.LogElement;
import io.netty.handler.codec.http.HttpHeaders;
import java.util.Map;
import java.util.StringJoiner;

final class HeadersElement
extends AbstractHttpMessageLogElement {
    private static final HeadersElement REQUEST_HEADERS_ELEMENT = new HeadersElement(true);
    private static final HeadersElement RESPONSE_HEADERS_ELEMENT = new HeadersElement(false);

    private HeadersElement(boolean onRequest) {
        this.events = onRequest ? LogElement.Event.REQUEST_HEADERS_EVENTS : LogElement.Event.RESPONSE_HEADERS_EVENTS;
    }

    public static HeadersElement forRequest() {
        return REQUEST_HEADERS_ELEMENT;
    }

    public static HeadersElement forResponse() {
        return RESPONSE_HEADERS_ELEMENT;
    }

    @Override
    protected String value(HttpHeaders headers) {
        if (headers.isEmpty()) {
            return "-";
        }
        if (headers.size() == 1) {
            Map.Entry header2 = (Map.Entry)headers.iteratorCharSequence().next();
            return String.valueOf(header2.getKey()) + ":" + String.valueOf(header2.getValue());
        }
        StringJoiner joiner = new StringJoiner(",", "[", "]");
        headers.forEach(header -> joiner.add((String)header.getKey() + ":" + (String)header.getValue()));
        return joiner.toString();
    }

    public String toString() {
        return this.events.contains((Object)LogElement.Event.ON_REQUEST_HEADERS) ? "i" : "o";
    }
}

