/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty;

import io.micronaut.buffer.netty.NettyReadBufferFactory;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.async.subscriber.LazySendingSubscriber;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.core.io.buffer.ReadBuffer;
import io.micronaut.core.io.buffer.ReadBufferFactory;
import io.micronaut.http.ByteBodyHttpResponse;
import io.micronaut.http.ByteBodyHttpResponseWrapper;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.body.ByteBody;
import io.micronaut.http.body.ByteBodyFactory;
import io.micronaut.http.body.CloseableByteBody;
import io.micronaut.http.body.ConcatenatingSubscriber;
import io.micronaut.http.body.stream.BufferConsumer;
import io.micronaut.http.netty.EventLoopFlow;
import io.micronaut.http.netty.NettyHttpResponseBuilder;
import io.micronaut.http.netty.body.NettyByteBodyFactory;
import io.micronaut.http.netty.body.StreamingNettyByteBody;
import io.micronaut.http.netty.stream.StreamedHttpResponse;
import io.micronaut.http.server.ResponseLifecycle;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.http.server.netty.RoutingInBoundHandler;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufHolder;
import io.netty.util.concurrent.OrderedEventExecutor;
import java.util.concurrent.Executor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.publisher.Flux;

@Internal
final class NettyResponseLifecycle
extends ResponseLifecycle {
    private final RoutingInBoundHandler routingInBoundHandler;
    private final NettyHttpRequest<?> request;

    public NettyResponseLifecycle(RoutingInBoundHandler routingInBoundHandler, NettyHttpRequest<?> request) {
        super(routingInBoundHandler.routeExecutor, routingInBoundHandler.messageBodyHandlerRegistry, routingInBoundHandler.conversionService, (ByteBodyFactory)new NettyByteBodyFactory(request.getChannelHandlerContext().channel()));
        this.routingInBoundHandler = routingInBoundHandler;
        this.request = request;
    }

    protected Executor ioExecutor() {
        return this.routingInBoundHandler.getIoExecutor();
    }

    protected ExecutionFlow<? extends ByteBodyHttpResponse<?>> encodeNoBody(HttpResponse<?> response) {
        NettyHttpResponseBuilder builder;
        io.netty.handler.codec.http.HttpResponse nettyResponse;
        if (response instanceof NettyHttpResponseBuilder && (nettyResponse = (builder = (NettyHttpResponseBuilder)response).toHttpResponse()) instanceof StreamedHttpResponse) {
            StreamedHttpResponse streamed = (StreamedHttpResponse)nettyResponse;
            return LazySendingSubscriber.create((Publisher)streamed).map(contents -> {
                CloseableByteBody body = this.byteBodyFactory().adapt((Publisher)Flux.from((Publisher)contents).map(ByteBufHolder::content), null, null);
                return ByteBodyHttpResponseWrapper.wrap((HttpResponse)response, (CloseableByteBody)body);
            }).onErrorResume(e -> this.handleStreamingError(this.request, (Throwable)e));
        }
        return super.encodeNoBody(response);
    }

    private NettyByteBodyFactory byteBodyFactory() {
        return new NettyByteBodyFactory(this.request.getChannelHandlerContext().channel());
    }

    @NonNull
    protected CloseableByteBody concatenate(Publisher<ByteBody> items) {
        return NettyConcatenatingSubscriber.concatenate(this.byteBodyFactory(), ConcatenatingSubscriber.Separators.NONE, items);
    }

    @NonNull
    protected CloseableByteBody concatenateJson(Publisher<ByteBody> items) {
        return NettyConcatenatingSubscriber.concatenate(this.byteBodyFactory(), NettyConcatenatingSubscriber.JSON_NETTY, items);
    }

    private static class NettyConcatenatingSubscriber
    extends ConcatenatingSubscriber
    implements BufferConsumer {
        static final ConcatenatingSubscriber.Separators JSON_NETTY = ConcatenatingSubscriber.Separators.jsonSeparators((ReadBufferFactory)NettyReadBufferFactory.of((ByteBufAllocator)ByteBufAllocator.DEFAULT));
        private final EventLoopFlow flow;

        NettyConcatenatingSubscriber(NettyByteBodyFactory byteBodyFactory, ConcatenatingSubscriber.Separators separators) {
            super((ByteBodyFactory)byteBodyFactory, separators);
            this.flow = new EventLoopFlow((OrderedEventExecutor)((StreamingNettyByteBody.SharedBuffer)this.sharedBuffer).eventLoop());
        }

        static CloseableByteBody concatenate(NettyByteBodyFactory byteBodyFactory, ConcatenatingSubscriber.Separators separators, Publisher<ByteBody> publisher) {
            NettyConcatenatingSubscriber subscriber = new NettyConcatenatingSubscriber(byteBodyFactory, separators);
            publisher.subscribe((Subscriber)subscriber);
            return subscriber.rootBody;
        }

        public void add(@NonNull ReadBuffer buffer) {
            if (this.flow.executeNow(() -> super.add(buffer))) {
                super.add(buffer);
            }
        }

        protected void forwardComplete() {
            if (this.flow.executeNow(() -> super.forwardComplete())) {
                super.forwardComplete();
            }
        }

        protected void forwardError(Throwable t) {
            if (this.flow.executeNow(() -> super.forwardError(t))) {
                super.forwardError(t);
            }
        }
    }
}

