/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.multipart;

import io.micronaut.core.annotation.Internal;
import io.netty.handler.codec.http.multipart.FileUpload;
import java.io.FileInputStream;
import java.io.IOException;
import javax.annotation.Nonnull;

@Internal
class NettyFileUploadInputStream
extends FileInputStream {
    @Nonnull
    private final FileUpload file;
    private final boolean releaseOnClose;

    NettyFileUploadInputStream(@Nonnull FileUpload file, boolean releaseOnClose) throws IOException {
        super(file.getFile());
        this.file = file;
        this.releaseOnClose = releaseOnClose;
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.releaseOnClose) {
            this.file.release();
        }
    }
}

