/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.types.files;

import io.micronaut.http.HttpRequest;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.netty.NettyMutableHttpResponse;
import io.micronaut.http.server.netty.SmartHttpContentCompressor;
import io.micronaut.http.server.netty.types.NettyFileCustomizableResponseType;
import io.micronaut.http.server.types.CustomizableResponseTypeException;
import io.micronaut.http.server.types.files.FileCustomizableResponseType;
import io.micronaut.http.server.types.files.SystemFile;
import io.micronaut.http.server.types.files.SystemFileCustomizableResponseType;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultFileRegion;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpChunkedInput;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedFile;
import io.netty.handler.stream.ChunkedInput;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettySystemFileCustomizableResponseType
extends SystemFileCustomizableResponseType
implements NettyFileCustomizableResponseType {
    private static final int LENGTH_8K = 8192;
    private static final Logger LOG = LoggerFactory.getLogger(NettySystemFileCustomizableResponseType.class);
    protected final RandomAccessFile raf;
    protected final long rafLength;
    protected Optional<FileCustomizableResponseType> delegate = Optional.empty();

    public NettySystemFileCustomizableResponseType(File file) {
        super(file);
        try {
            this.raf = new RandomAccessFile(file, "r");
        }
        catch (FileNotFoundException e) {
            throw new CustomizableResponseTypeException("Could not find file", (Throwable)e);
        }
        try {
            this.rafLength = this.raf.length();
        }
        catch (IOException e) {
            throw new CustomizableResponseTypeException("Could not determine file length", (Throwable)e);
        }
    }

    public NettySystemFileCustomizableResponseType(SystemFileCustomizableResponseType delegate) {
        this(delegate.getFile());
        this.delegate = Optional.of(delegate);
    }

    public NettySystemFileCustomizableResponseType(SystemFile delegate) {
        this(delegate.getFile());
        this.delegate = Optional.of(delegate);
    }

    public long getLength() {
        return this.rafLength;
    }

    public long getLastModified() {
        return this.delegate.map(FileCustomizableResponseType::getLastModified).orElse(super.getLastModified());
    }

    @Deprecated
    public String getName() {
        return this.delegate.map(FileCustomizableResponseType::getName).orElse(super.getName());
    }

    public MediaType getMediaType() {
        return this.delegate.map(FileCustomizableResponseType::getMediaType).orElse(super.getMediaType());
    }

    public void process(MutableHttpResponse response) {
        response.header((CharSequence)"Content-Length", (CharSequence)String.valueOf(this.getLength()));
        this.delegate.ifPresent(type -> type.process(response));
    }

    @Override
    public void write(HttpRequest<?> request, MutableHttpResponse<?> response, ChannelHandlerContext context) {
        ChannelFuture sendFileFuture;
        if (response instanceof NettyMutableHttpResponse) {
            FullHttpResponse nettyResponse = ((NettyMutableHttpResponse)response).getNativeResponse();
            HttpHeaders headers = nettyResponse.headers();
            context.write((Object)new DefaultHttpResponse(nettyResponse.protocolVersion(), nettyResponse.status(), headers), context.voidPromise());
            if (context.pipeline().get(SslHandler.class) == null && ((SmartHttpContentCompressor)context.pipeline().get(SmartHttpContentCompressor.class)).shouldSkip((HttpResponse)nettyResponse)) {
                sendFileFuture = context.write((Object)new DefaultFileRegion(this.raf.getChannel(), 0L, this.getLength()), (ChannelPromise)context.newProgressivePromise());
                context.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
            } else {
                try {
                    sendFileFuture = context.writeAndFlush((Object)new HttpChunkedInput((ChunkedInput)new ChunkedFile(this.raf, 0L, this.getLength(), 8192)), (ChannelPromise)context.newProgressivePromise());
                }
                catch (IOException e) {
                    throw new CustomizableResponseTypeException("Could not read file", (Throwable)e);
                }
            }
        } else {
            throw new IllegalArgumentException("Unsupported response type. Not a Netty response: " + response);
        }
        sendFileFuture.addListener(future -> {
            try {
                this.raf.close();
            }
            catch (IOException e) {
                LOG.warn("An error occurred closing the file reference: " + this.file.getAbsolutePath(), (Throwable)e);
            }
        });
    }
}

