/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty.channel.loom;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.SupplierUtil;
import io.micronaut.scheduling.LoomSupport;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.concurrent.FutureTask;
import java.util.function.Supplier;

@Internal
public final class LoomBranchSupport {
    private static final Supplier<VirtualThreadSchedulerProxy> DEFAULT_SCHEDULER;
    private static final Thread DEFAULT_SCHEDULER_THREAD;
    private static final MethodHandle TO_JDK_SCHEDULER;
    private static final MethodHandle TO_OUR_SCHEDULER;
    private static final MethodHandle CURRENT_SCHEDULER;
    private static final MethodHandle JDK_EXECUTE;
    private static final MethodHandle SET_SCHEDULER;
    private static final Class<?> PROXY_LAMBDA_CLASS;

    public static boolean isSupported() {
        return TO_OUR_SCHEDULER != null;
    }

    static void runOnDefaultScheduler(Runnable r) {
        DEFAULT_SCHEDULER.get().execute(DEFAULT_SCHEDULER_THREAD, r);
    }

    static VirtualThreadSchedulerProxy currentScheduler() {
        return LoomBranchSupport.toOurScheduler(LoomBranchSupport.currentPrivate());
    }

    private static Object currentPrivate() {
        try {
            return CURRENT_SCHEDULER.invokeExact();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    static Object toJdkScheduler(VirtualThreadSchedulerProxy proxy) {
        try {
            return TO_JDK_SCHEDULER.invokeExact(proxy);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    static VirtualThreadSchedulerProxy toOurScheduler(Object scheduler) {
        if (scheduler.getClass() == PROXY_LAMBDA_CLASS) {
            UnwrapClass unwrapClass = new UnwrapClass();
            try {
                JDK_EXECUTE.invokeExact(scheduler, null, unwrapClass);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
            return unwrapClass.proxy;
        }
        try {
            return TO_OUR_SCHEDULER.invokeExact(scheduler);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static void setScheduler(Object builder, VirtualThreadSchedulerProxy scheduler) {
        try {
            SET_SCHEDULER.invokeExact(builder, LoomBranchSupport.toJdkScheduler(scheduler));
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private static void executeOrUnwrap(VirtualThreadSchedulerProxy target, Thread thread, Runnable task) {
        if (task instanceof UnwrapClass) {
            UnwrapClass uc = (UnwrapClass)task;
            uc.proxy = target;
            return;
        }
        target.execute(thread, task);
    }

    static {
        MethodHandle setScheduler;
        MethodHandle toOurScheduler;
        MethodHandle toJdkScheduler;
        MethodHandle jdkExecute;
        MethodHandle currentScheduler;
        try {
            MethodType executeMethodType = MethodType.methodType(Void.TYPE, Thread.class, Runnable.class);
            Class<?> jdkVirtualThreadScheduler = Class.forName("java.lang.Thread$VirtualThreadScheduler");
            currentScheduler = MethodHandles.lookup().findStatic(jdkVirtualThreadScheduler, "current", MethodType.methodType(jdkVirtualThreadScheduler)).asType(MethodType.methodType(Object.class));
            jdkExecute = MethodHandles.lookup().findVirtual(jdkVirtualThreadScheduler, "execute", executeMethodType);
            MethodHandle ourExecute = MethodHandles.lookup().findStatic(LoomBranchSupport.class, "executeOrUnwrap", MethodType.methodType(Void.TYPE, VirtualThreadSchedulerProxy.class, Thread.class, Runnable.class));
            toJdkScheduler = LambdaMetafactory.metafactory(MethodHandles.lookup(), "execute", MethodType.methodType(jdkVirtualThreadScheduler, VirtualThreadSchedulerProxy.class), executeMethodType, ourExecute, executeMethodType).dynamicInvoker().asType(MethodType.methodType(Object.class, VirtualThreadSchedulerProxy.class));
            toOurScheduler = LambdaMetafactory.metafactory(MethodHandles.lookup(), "execute", MethodType.methodType(VirtualThreadSchedulerProxy.class, jdkVirtualThreadScheduler), executeMethodType, jdkExecute, executeMethodType).dynamicInvoker().asType(MethodType.methodType(VirtualThreadSchedulerProxy.class, Object.class));
            Class<?> ofVirtual = Class.forName("java.lang.Thread$Builder$OfVirtual");
            setScheduler = MethodHandles.lookup().findVirtual(ofVirtual, "scheduler", MethodType.methodType(ofVirtual, jdkVirtualThreadScheduler)).asType(MethodType.methodType(Void.TYPE, Object.class, Object.class));
        }
        catch (Exception e) {
            jdkExecute = null;
            toJdkScheduler = null;
            toOurScheduler = null;
            currentScheduler = null;
            setScheduler = null;
        }
        TO_JDK_SCHEDULER = toJdkScheduler;
        TO_OUR_SCHEDULER = toOurScheduler;
        CURRENT_SCHEDULER = currentScheduler;
        JDK_EXECUTE = jdkExecute == null ? null : jdkExecute.asType(MethodType.methodType(Void.TYPE, Object.class, Thread.class, Runnable.class));
        SET_SCHEDULER = setScheduler;
        Class<?> clazz = PROXY_LAMBDA_CLASS = TO_JDK_SCHEDULER != null ? LoomBranchSupport.toJdkScheduler((thread, runnable) -> {}).getClass() : null;
        if (LoomBranchSupport.isSupported()) {
            FutureTask<Object> task = new FutureTask<Object>(LoomBranchSupport::currentPrivate);
            DEFAULT_SCHEDULER_THREAD = LoomSupport.newVirtualThreadFactory((String)"default-scheduler-exposer").newThread(task);
            DEFAULT_SCHEDULER_THREAD.start();
            DEFAULT_SCHEDULER = SupplierUtil.memoized(() -> {
                try {
                    return LoomBranchSupport.toOurScheduler(task.get());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        } else {
            DEFAULT_SCHEDULER_THREAD = null;
            DEFAULT_SCHEDULER = null;
        }
    }

    static interface VirtualThreadSchedulerProxy {
        public void execute(Thread var1, Runnable var2);
    }

    private static final class UnwrapClass
    implements Runnable {
        VirtualThreadSchedulerProxy proxy;

        private UnwrapClass() {
        }

        @Override
        public void run() {
            throw new UnsupportedOperationException();
        }
    }
}

