/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty.channel;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.annotation.Order;
import io.micronaut.http.netty.channel.EventLoopGroupConfiguration;
import io.micronaut.http.netty.channel.EventLoopGroupFactory;
import io.micronaut.http.netty.channel.IoUringAvailabilityCondition;
import io.micronaut.http.netty.channel.NettyChannelType;
import io.netty.channel.Channel;
import io.netty.channel.IoHandlerFactory;
import io.netty.channel.uring.IoUring;
import io.netty.channel.uring.IoUringDatagramChannel;
import io.netty.channel.uring.IoUringIoHandler;
import io.netty.channel.uring.IoUringServerSocketChannel;
import io.netty.channel.uring.IoUringSocketChannel;
import jakarta.inject.Named;
import jakarta.inject.Singleton;

@Singleton
@Requires(classes={IoUring.class}, condition=IoUringAvailabilityCondition.class)
@Internal
@Named(value="io_uring")
@BootstrapContextCompatible
@Order(value=200)
public class IoUringEventLoopGroupFactory
implements EventLoopGroupFactory {
    public static final String NAME = "io_uring";

    @Override
    public IoHandlerFactory createIoHandlerFactory() {
        return IoUringIoHandler.newFactory();
    }

    @Override
    public boolean isNative() {
        return true;
    }

    @Override
    public Class<? extends Channel> channelClass(NettyChannelType type) throws UnsupportedOperationException {
        return switch (type) {
            case NettyChannelType.SERVER_SOCKET -> IoUringServerSocketChannel.class;
            case NettyChannelType.CLIENT_SOCKET -> IoUringSocketChannel.class;
            case NettyChannelType.DATAGRAM_SOCKET -> IoUringDatagramChannel.class;
            default -> throw new UnsupportedOperationException("Channel type not supported");
        };
    }

    @Override
    public Class<? extends Channel> channelClass(NettyChannelType type, @Nullable EventLoopGroupConfiguration configuration) {
        return this.channelClass(type);
    }

    @Override
    public Channel channelInstance(NettyChannelType type, @Nullable EventLoopGroupConfiguration configuration) {
        return switch (type) {
            case NettyChannelType.SERVER_SOCKET -> new IoUringServerSocketChannel();
            case NettyChannelType.CLIENT_SOCKET -> new IoUringSocketChannel();
            case NettyChannelType.DATAGRAM_SOCKET -> new IoUringDatagramChannel();
            default -> throw new UnsupportedOperationException("Channel type not supported");
        };
    }
}

