/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty.channel;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.annotation.Order;
import io.micronaut.http.netty.channel.EpollAvailabilityCondition;
import io.micronaut.http.netty.channel.EventLoopGroupConfiguration;
import io.micronaut.http.netty.channel.EventLoopGroupFactory;
import io.micronaut.http.netty.channel.NettyChannelType;
import io.netty.channel.Channel;
import io.netty.channel.IoHandlerFactory;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollDomainSocketChannel;
import io.netty.channel.epoll.EpollIoHandler;
import io.netty.channel.epoll.EpollServerDomainSocketChannel;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Requires(classes={Epoll.class}, condition=EpollAvailabilityCondition.class)
@Internal
@Named(value="epoll")
@BootstrapContextCompatible
@Order(value=100)
public class EpollEventLoopGroupFactory
implements EventLoopGroupFactory {
    public static final String NAME = "epoll";
    private static final Logger LOG = LoggerFactory.getLogger(EpollEventLoopGroupFactory.class);

    @Override
    public IoHandlerFactory createIoHandlerFactory() {
        return EpollIoHandler.newFactory();
    }

    @Override
    public boolean isNative() {
        return true;
    }

    @Override
    public Class<? extends Channel> channelClass(NettyChannelType type) throws UnsupportedOperationException {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case NettyChannelType.SERVER_SOCKET -> EpollServerSocketChannel.class;
            case NettyChannelType.CLIENT_SOCKET -> EpollSocketChannel.class;
            case NettyChannelType.DOMAIN_SOCKET -> EpollDomainSocketChannel.class;
            case NettyChannelType.DOMAIN_SERVER_SOCKET -> EpollServerDomainSocketChannel.class;
            case NettyChannelType.DATAGRAM_SOCKET -> EpollDatagramChannel.class;
        };
    }

    @Override
    public Class<? extends Channel> channelClass(NettyChannelType type, @Nullable EventLoopGroupConfiguration configuration) {
        return this.channelClass(type);
    }

    @Override
    public Channel channelInstance(NettyChannelType type, @Nullable EventLoopGroupConfiguration configuration) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case NettyChannelType.SERVER_SOCKET -> new EpollServerSocketChannel();
            case NettyChannelType.CLIENT_SOCKET -> new EpollSocketChannel();
            case NettyChannelType.DOMAIN_SOCKET -> new EpollDomainSocketChannel();
            case NettyChannelType.DOMAIN_SERVER_SOCKET -> new EpollServerDomainSocketChannel();
            case NettyChannelType.DATAGRAM_SOCKET -> new EpollDatagramChannel();
        };
    }

    @Override
    public Channel channelInstance(NettyChannelType type, EventLoopGroupConfiguration configuration, Channel parent, int fd) {
        if (parent != null) {
            LOG.warn("epoll does not support FD-based channels with a parent channel. This may cause issues with HTTP2.");
        }
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case NettyChannelType.SERVER_SOCKET -> new EpollServerSocketChannel(fd);
            case NettyChannelType.CLIENT_SOCKET -> new EpollSocketChannel(fd);
            case NettyChannelType.DOMAIN_SOCKET -> new EpollDomainSocketChannel(fd);
            case NettyChannelType.DOMAIN_SERVER_SOCKET -> new EpollServerDomainSocketChannel(fd, true);
            case NettyChannelType.DATAGRAM_SOCKET -> new EpollDatagramChannel(fd);
        };
    }
}

