/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty.body;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.execution.DelayedExecutionFlow;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.core.io.buffer.ReadBuffer;
import io.micronaut.core.io.buffer.ReadBufferFactory;
import io.micronaut.core.util.SupplierUtil;
import io.micronaut.http.body.ByteBody;
import io.micronaut.http.body.CloseableAvailableByteBody;
import io.micronaut.http.body.CloseableByteBody;
import io.micronaut.http.body.stream.BaseSharedBuffer;
import io.micronaut.http.body.stream.BaseStreamingByteBody;
import io.micronaut.http.body.stream.BodySizeLimits;
import io.micronaut.http.body.stream.BufferConsumer;
import io.micronaut.http.body.stream.UpstreamBalancer;
import io.micronaut.http.netty.body.NettyByteBodyFactory;
import io.netty.channel.EventLoop;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.ResourceLeakDetectorFactory;
import io.netty.util.ResourceLeakTracker;
import java.util.function.Supplier;

@Internal
public final class StreamingNettyByteBody
extends BaseStreamingByteBody<SharedBuffer>
implements CloseableByteBody {
    private final boolean forceDelaySubscribe;

    public StreamingNettyByteBody(SharedBuffer sharedBuffer) {
        this(sharedBuffer, false, sharedBuffer.getRootUpstream());
    }

    private StreamingNettyByteBody(SharedBuffer sharedBuffer, boolean forceDelaySubscribe, BufferConsumer.Upstream upstream) {
        super((BaseSharedBuffer)sharedBuffer, upstream);
        this.forceDelaySubscribe = forceDelaySubscribe;
    }

    public BufferConsumer.Upstream primary(BufferConsumer primary) {
        this.touch();
        BufferConsumer.Upstream upstream = this.upstream;
        if (upstream == null) {
            this.failClaim();
        }
        this.recordPrimaryOp();
        this.upstream = null;
        BaseSharedBuffer.logClaim();
        ((SharedBuffer)this.sharedBuffer).subscribe(primary, upstream, this.forceDelaySubscribe);
        return upstream;
    }

    protected BaseStreamingByteBody<SharedBuffer> derive(BufferConsumer.Upstream upstream) {
        return new StreamingNettyByteBody((SharedBuffer)this.sharedBuffer, this.forceDelaySubscribe, upstream);
    }

    @NonNull
    public CloseableByteBody split(@NonNull ByteBody.SplitBackpressureMode backpressureMode) {
        this.touch();
        BufferConsumer.Upstream upstream = this.upstream;
        if (upstream == null) {
            this.failClaim();
        }
        UpstreamBalancer.UpstreamPair pair = UpstreamBalancer.balancer((BufferConsumer.Upstream)upstream, (ByteBody.SplitBackpressureMode)backpressureMode);
        this.upstream = pair.left();
        boolean forceDelaySubscribe = ((SharedBuffer)this.sharedBuffer).reserve();
        return new StreamingNettyByteBody((SharedBuffer)this.sharedBuffer, forceDelaySubscribe, pair.right());
    }

    @NonNull
    public ExecutionFlow<? extends CloseableAvailableByteBody> bufferFlow() {
        BufferConsumer.Upstream upstream = this.upstream;
        if (upstream == null) {
            this.failClaim();
        }
        this.recordPrimaryOp();
        this.upstream = null;
        BaseSharedBuffer.logClaim();
        upstream.start();
        upstream.onBytesConsumed(Long.MAX_VALUE);
        return ((SharedBuffer)this.sharedBuffer).subscribeFull(upstream, this.forceDelaySubscribe).map(arg_0 -> ((NettyByteBodyFactory)((SharedBuffer)this.sharedBuffer).byteBodyFactory).adapt(arg_0));
    }

    public void close() {
        this.touch();
        BufferConsumer.Upstream upstream = this.upstream;
        if (upstream == null) {
            return;
        }
        this.recordClosed();
        this.upstream = null;
        BaseSharedBuffer.logClaim();
        upstream.allowDiscard();
        upstream.disregardBackpressure();
        upstream.start();
        ((SharedBuffer)this.sharedBuffer).subscribe(null, upstream, this.forceDelaySubscribe);
    }

    public void touch() {
        ResourceLeakTracker<SharedBuffer> tracker = ((SharedBuffer)this.sharedBuffer).tracker;
        if (tracker != null) {
            tracker.record();
        }
    }

    @Internal
    public static final class SharedBuffer
    extends BaseSharedBuffer {
        private static final Supplier<ResourceLeakDetector<SharedBuffer>> LEAK_DETECTOR = SupplierUtil.memoized(() -> ResourceLeakDetectorFactory.instance().newResourceLeakDetector(SharedBuffer.class));
        @Nullable
        private final ResourceLeakTracker<SharedBuffer> tracker = LEAK_DETECTOR.get().track((Object)this);
        private final EventLoop eventLoop;
        private final NettyByteBodyFactory byteBodyFactory;
        private boolean adding = false;

        public SharedBuffer(EventLoop loop, NettyByteBodyFactory byteBodyFactory, BodySizeLimits limits, BufferConsumer.Upstream rootUpstream) {
            super((ReadBufferFactory)byteBodyFactory.readBufferFactory(), limits, rootUpstream);
            this.eventLoop = loop;
            this.byteBodyFactory = byteBodyFactory;
        }

        public EventLoop eventLoop() {
            return this.eventLoop;
        }

        public void setExpectedLengthFrom(HttpHeaders headers) {
            this.setExpectedLengthFrom(headers.get((CharSequence)HttpHeaderNames.CONTENT_LENGTH));
        }

        boolean reserve() {
            if (this.eventLoop.inEventLoop() && !this.adding) {
                this.reserve0();
                return false;
            }
            this.eventLoop.execute(this::reserve0);
            return true;
        }

        protected void reserve0() {
            super.reserve0();
            if (this.tracker != null) {
                this.tracker.record();
            }
        }

        void subscribe(@Nullable BufferConsumer subscriber, BufferConsumer.Upstream specificUpstream, boolean forceDelay) {
            if (!forceDelay && this.eventLoop.inEventLoop() && !this.adding) {
                this.subscribe0(subscriber, specificUpstream);
            } else {
                this.eventLoop.execute(() -> this.subscribe0(subscriber, specificUpstream));
            }
        }

        protected void afterSubscribe(boolean last) {
            if (this.tracker != null) {
                if (last) {
                    this.tracker.close((Object)this);
                } else {
                    this.tracker.record();
                }
            }
        }

        ExecutionFlow<ReadBuffer> subscribeFull(BufferConsumer.Upstream specificUpstream, boolean forceDelay) {
            DelayedExecutionFlow asyncFlow = DelayedExecutionFlow.create();
            if (!forceDelay && this.eventLoop.inEventLoop() && !this.adding) {
                return this.subscribeFull0(asyncFlow, specificUpstream, true);
            }
            this.eventLoop.execute(() -> {
                ExecutionFlow res = this.subscribeFull0(asyncFlow, specificUpstream, false);
                assert (res == asyncFlow);
            });
            return asyncFlow;
        }

        public void add(ReadBuffer rb) {
            assert (this.eventLoop.inEventLoop());
            this.adding = true;
            try {
                super.add(rb);
            }
            finally {
                this.adding = false;
            }
        }
    }
}

