/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty.body;

import io.micronaut.buffer.netty.NettyByteBufferFactory;
import io.micronaut.buffer.netty.NettyReadBufferFactory;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.io.buffer.ByteBufferFactory;
import io.micronaut.core.io.buffer.ReadBuffer;
import io.micronaut.core.io.buffer.ReadBufferFactory;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.body.AbstractBodyAdapter;
import io.micronaut.http.body.AvailableByteBody;
import io.micronaut.http.body.ByteBody;
import io.micronaut.http.body.ByteBodyFactory;
import io.micronaut.http.body.CloseableAvailableByteBody;
import io.micronaut.http.body.CloseableByteBody;
import io.micronaut.http.body.stream.AvailableByteArrayBody;
import io.micronaut.http.body.stream.BaseSharedBuffer;
import io.micronaut.http.body.stream.BaseStreamingByteBody;
import io.micronaut.http.body.stream.BodySizeLimits;
import io.micronaut.http.body.stream.BufferConsumer;
import io.micronaut.http.netty.NettyHttpHeaders;
import io.micronaut.http.netty.body.NettyBodyAdapter;
import io.micronaut.http.netty.body.StreamingNettyByteBody;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.EventLoop;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

@Internal
public final class NettyByteBodyFactory
extends ByteBodyFactory {
    private final EventLoop loop;

    public NettyByteBodyFactory(@NonNull Channel channel) {
        this(channel.alloc(), channel.eventLoop());
    }

    NettyByteBodyFactory(ByteBufAllocator alloc, EventLoop loop) {
        super((ByteBufferFactory)new NettyByteBufferFactory(alloc), (ReadBufferFactory)NettyReadBufferFactory.of((ByteBufAllocator)alloc));
        this.loop = loop;
    }

    @NonNull
    public NettyReadBufferFactory readBufferFactory() {
        return (NettyReadBufferFactory)super.readBufferFactory();
    }

    public ByteBodyFactory.StreamingBody createStreamingBody(BodySizeLimits limits, BufferConsumer.Upstream upstream) {
        StreamingNettyByteBody.SharedBuffer sb = this.createStreamingBuffer(BodySizeLimits.UNLIMITED, upstream);
        return new ByteBodyFactory.StreamingBody((BaseSharedBuffer)sb, (BaseStreamingByteBody)new StreamingNettyByteBody(sb));
    }

    protected AbstractBodyAdapter createBodyAdapter(Publisher<ReadBuffer> publisher, Runnable onDiscard) {
        return new NettyBodyAdapter(this.loop, publisher, onDiscard);
    }

    public CloseableAvailableByteBody adapt(ByteBuf byteBuf) {
        return this.adapt(this.readBufferFactory().adapt(byteBuf));
    }

    public CloseableByteBody createChecked(@NonNull BodySizeLimits bodySizeLimits, @NonNull ByteBuf buf) {
        int readable = buf.readableBytes();
        if ((long)readable > bodySizeLimits.maxBodySize() || (long)readable > bodySizeLimits.maxBufferSize()) {
            BufferConsumer.Upstream upstream = bytesConsumed -> {};
            StreamingNettyByteBody.SharedBuffer mockBuffer = this.createStreamingBuffer(bodySizeLimits, upstream);
            mockBuffer.add(this.readBufferFactory().adapt(buf));
            return new StreamingNettyByteBody(mockBuffer);
        }
        return this.adapt(buf);
    }

    public CloseableByteBody adaptNetty(Publisher<ByteBuf> publisher) {
        return this.adapt(publisher, null, null);
    }

    public CloseableByteBody adapt(Publisher<ByteBuf> publisher, @Nullable io.netty.handler.codec.http.HttpHeaders headersForLength, @Nullable Runnable onDiscard) {
        return this.adapt((Publisher)Flux.from(publisher).map(arg_0 -> ((NettyReadBufferFactory)this.readBufferFactory()).adapt(arg_0)), BodySizeLimits.UNLIMITED, (HttpHeaders)(headersForLength == null ? null : new NettyHttpHeaders(headersForLength, ConversionService.SHARED)), onDiscard);
    }

    public static CloseableAvailableByteBody empty() {
        return AvailableByteArrayBody.create((ReadBuffer)NettyReadBufferFactory.of((ByteBufAllocator)ByteBufAllocator.DEFAULT).createEmpty());
    }

    public static ByteBuf toByteBuf(AvailableByteBody body) {
        try (ReadBuffer rb = body.toReadBuffer();){
            ByteBuf byteBuf = NettyReadBufferFactory.toByteBuf((ReadBuffer)rb);
            return byteBuf;
        }
    }

    public static Flux<ByteBuf> toByteBufs(ByteBody body) {
        return Flux.from((Publisher)body.toReadBufferPublisher()).map(NettyReadBufferFactory::toByteBuf);
    }

    public StreamingNettyByteBody.SharedBuffer createStreamingBuffer(BodySizeLimits limits, BufferConsumer.Upstream rootUpstream) {
        return new StreamingNettyByteBody.SharedBuffer(this.loop, this, limits, rootUpstream);
    }

    public StreamingNettyByteBody toStreaming(ByteBody body) {
        if (body instanceof StreamingNettyByteBody) {
            StreamingNettyByteBody snbb = (StreamingNettyByteBody)body;
            return snbb;
        }
        NettyBodyAdapter adapter = new NettyBodyAdapter(this.loop, (Publisher<ReadBuffer>)body.toReadBufferPublisher(), null);
        StreamingNettyByteBody.SharedBuffer sb = this.createStreamingBuffer(BodySizeLimits.UNLIMITED, (BufferConsumer.Upstream)adapter);
        adapter.setSharedBuffer(sb);
        body.expectedLength().ifPresent(arg_0 -> ((StreamingNettyByteBody.SharedBuffer)sb).setExpectedLength(arg_0));
        return new StreamingNettyByteBody(sb);
    }
}

