/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty.body;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.io.buffer.ReadBuffer;
import io.micronaut.http.body.AbstractBodyAdapter;
import io.micronaut.http.netty.EventLoopFlow;
import io.netty.channel.EventLoop;
import io.netty.util.concurrent.OrderedEventExecutor;
import org.reactivestreams.Publisher;

@Internal
final class NettyBodyAdapter
extends AbstractBodyAdapter {
    private final EventLoopFlow eventLoopFlow;

    NettyBodyAdapter(EventLoop eventLoop, Publisher<ReadBuffer> source, @Nullable Runnable onDiscard) {
        super(source, onDiscard);
        this.eventLoopFlow = new EventLoopFlow((OrderedEventExecutor)eventLoop);
    }

    public void onNext(ReadBuffer bytes) {
        if (this.eventLoopFlow.executeNow(() -> super.onNext(bytes))) {
            super.onNext(bytes);
        }
    }

    public void onError(Throwable t) {
        if (this.eventLoopFlow.executeNow(() -> super.onError(t))) {
            super.onError(t);
        }
    }

    public void onComplete() {
        if (this.eventLoopFlow.executeNow(() -> super.onComplete())) {
            super.onComplete();
        }
    }
}

