/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.tck.tests.filter;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.ClientFilter;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.RequestFilter;
import io.micronaut.http.filter.FilterContinuation;
import io.micronaut.http.tck.AssertionUtils;
import io.micronaut.http.tck.HttpResponseAssertion;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.http.tck.TestScenario;
import io.micronaut.scheduling.annotation.ExecuteOn;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ClientRequestFilterTest {
    public static final String SPEC_NAME = "ClientRequestFilterTest";

    @Test
    public void requestFilterImmediateRequestParameter() throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.GET((String)"/request-filter/immediate-request-parameter")).assertion((server, request) -> {
            AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("foo").build());
            Assertions.assertEquals(List.of("requestFilterImmediateRequestParameter /request-filter/immediate-request-parameter"), ((MyClientFilter)server.getApplicationContext().getBean(MyClientFilter.class)).events);
        }).run();
    }

    @Test
    public void requestFilterImmediateMutableRequestParameter() throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.GET((String)"/request-filter/immediate-mutable-request-parameter")).assertion((server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("bar").build())).run();
    }

    @Test
    @Disabled
    public void requestFilterReplaceRequest() throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.GET((String)"/request-filter/replace-request")).assertion((server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("/request-filter/replace-request-2").build())).run();
    }

    @Test
    @Disabled
    public void requestFilterReplaceMutableRequest() throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.GET((String)"/request-filter/replace-mutable-request")).assertion((server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("/request-filter/replace-mutable-request-2").build())).run();
    }

    @Test
    public void requestFilterReplaceRequestNull() throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.GET((String)"/request-filter/replace-request-null")).assertion((server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("/request-filter/replace-request-null").build())).run();
    }

    @Test
    public void requestFilterReplaceRequestEmpty() throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.GET((String)"/request-filter/replace-request-empty")).assertion((server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("/request-filter/replace-request-empty").build())).run();
    }

    @Test
    @Disabled
    public void requestFilterReplaceRequestPublisher() throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.GET((String)"/request-filter/replace-request-publisher")).assertion((server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("/request-filter/replace-request-publisher-2").build())).run();
    }

    @Test
    @Disabled
    public void requestFilterReplaceRequestMono() throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.GET((String)"/request-filter/replace-request-mono")).assertion((server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("/request-filter/replace-request-mono-2").build())).run();
    }

    @Test
    @Disabled
    public void requestFilterReplaceRequestCompletable() throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.GET((String)"/request-filter/replace-request-completable")).assertion((server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("/request-filter/replace-request-completable-2").build())).run();
    }

    @Test
    @Disabled
    public void requestFilterReplaceRequestCompletion() throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.GET((String)"/request-filter/replace-request-completion")).assertion((server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("/request-filter/replace-request-completion-2").build())).run();
    }

    @Test
    public void requestFilterContinuationBlocking() throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.GET((String)"/request-filter/continuation-blocking")).assertion((server, request) -> {
            AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("bar").build());
            Assertions.assertEquals(List.of("requestFilterContinuationBlocking bar"), ((MyClientFilter)server.getApplicationContext().getBean(MyClientFilter.class)).events);
        }).run();
    }

    @Test
    public void requestFilterContinuationReactivePublisher() throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.GET((String)"/request-filter/continuation-reactive-publisher")).assertion((server, request) -> {
            AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("bar").build());
            Assertions.assertEquals(List.of("requestFilterContinuationReactivePublisher bar"), ((MyClientFilter)server.getApplicationContext().getBean(MyClientFilter.class)).events);
        }).run();
    }

    @Test
    @Disabled
    public void requestFilterContinuationUpdateRequest() throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.GET((String)"/request-filter/continuation-update-request")).assertion((server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("/request-filter/continuation-update-request-2").build())).run();
    }

    @Test
    public void requestFilterImmediateResponse() throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.GET((String)"/request-filter/immediate-response")).assertion((server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("requestFilterImmediateResponse").build())).run();
    }

    @Test
    public void requestFilterNullResponse() throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.GET((String)"/request-filter/null-response")).assertion((server, request) -> {
            AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("foo").build());
            Assertions.assertEquals(List.of("requestFilterNullResponse"), ((MyClientFilter)server.getApplicationContext().getBean(MyClientFilter.class)).events);
        }).run();
    }

    @Test
    public void requestFilterEmptyOptionalResponse() throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.GET((String)"/request-filter/empty-optional-response")).assertion((server, request) -> {
            AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("foo").build());
            Assertions.assertEquals(List.of("requestFilterEmptyOptionalResponse"), ((MyClientFilter)server.getApplicationContext().getBean(MyClientFilter.class)).events);
        }).run();
    }

    @Test
    public void requestFilterPublisherResponse() throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.GET((String)"/request-filter/publisher-response")).assertion((server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("requestFilterPublisherResponse").build())).run();
    }

    @Test
    public void requestFilterMonoResponse() throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.GET((String)"/request-filter/mono-response")).assertion((server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("requestFilterMonoResponse").build())).run();
    }

    @Test
    public void requestFilterCompletableResponse() throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.GET((String)"/request-filter/completable-response")).assertion((server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("requestFilterCompletableResponse").build())).run();
    }

    @Test
    public void requestFilterCompletionResponse() throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.GET((String)"/request-filter/completion-response")).assertion((server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("requestFilterCompletionResponse").build())).run();
    }

    @ClientFilter
    @Singleton
    @Requires(property="spec.name", value="ClientRequestFilterTest")
    public static class MyClientFilter {
        List<String> events = new ArrayList<String>();

        @RequestFilter(value={"/request-filter/immediate-request-parameter"})
        public void requestFilterImmediateRequestParameter(HttpRequest<?> request) {
            this.events.add("requestFilterImmediateRequestParameter " + request.getPath());
        }

        @RequestFilter(value={"/request-filter/immediate-mutable-request-parameter"})
        public void requestFilterImmediateMutableRequestParameter(MutableHttpRequest<?> request) {
            request.header((CharSequence)"foo", (CharSequence)"bar");
        }

        @RequestFilter(value={"/request-filter/replace-request"})
        public HttpRequest<Object> requestFilterReplaceRequest() {
            return HttpRequest.GET((String)"/request-filter/replace-request-2");
        }

        @RequestFilter(value={"/request-filter/replace-mutable-request"})
        public MutableHttpRequest<Object> requestFilterReplaceMutableRequest() {
            return HttpRequest.GET((String)"/request-filter/replace-mutable-request-2");
        }

        @RequestFilter(value={"/request-filter/replace-request-null"})
        public @Nullable HttpRequest<Object> requestFilterReplaceRequestNull() {
            return null;
        }

        @RequestFilter(value={"/request-filter/replace-request-empty"})
        public Optional<HttpRequest<Object>> requestFilterReplaceRequestEmpty() {
            return Optional.empty();
        }

        @RequestFilter(value={"/request-filter/replace-request-publisher"})
        public Publisher<HttpRequest<Object>> requestFilterReplaceRequestPublisher() {
            return Flux.just((Object)HttpRequest.GET((String)"/request-filter/replace-request-publisher-2"));
        }

        @RequestFilter(value={"/request-filter/replace-request-mono"})
        public Mono<HttpRequest<Object>> requestFilterReplaceRequestMono() {
            return Mono.just((Object)HttpRequest.GET((String)"/request-filter/replace-request-mono-2"));
        }

        @RequestFilter(value={"/request-filter/replace-request-completable"})
        public CompletableFuture<HttpRequest<Object>> requestFilterReplaceRequestCompletable() {
            return CompletableFuture.completedFuture(HttpRequest.GET((String)"/request-filter/replace-request-completable-2"));
        }

        @RequestFilter(value={"/request-filter/replace-request-completion"})
        public CompletionStage<HttpRequest<Object>> requestFilterReplaceRequestCompletion() {
            return CompletableFuture.completedStage(HttpRequest.GET((String)"/request-filter/replace-request-completion-2"));
        }

        @RequestFilter(value={"/request-filter/continuation-blocking"})
        @ExecuteOn(value="blocking")
        public void requestFilterContinuationBlocking(MutableHttpRequest<?> request, FilterContinuation<HttpResponse<?>> continuation) {
            request.header((CharSequence)"foo", (CharSequence)"bar");
            HttpResponse r = (HttpResponse)continuation.proceed();
            this.events.add("requestFilterContinuationBlocking " + String.valueOf(r.body()));
        }

        @RequestFilter(value={"/request-filter/continuation-reactive-publisher"})
        public Publisher<HttpResponse<?>> requestFilterContinuationReactivePublisher(MutableHttpRequest<?> request, FilterContinuation<Publisher<HttpResponse<?>>> continuation) {
            request.header((CharSequence)"foo", (CharSequence)"bar");
            return Mono.from((Publisher)((Publisher)continuation.proceed())).doOnNext(r -> this.events.add("requestFilterContinuationReactivePublisher " + String.valueOf(r.body())));
        }

        @RequestFilter(value={"/request-filter/continuation-update-request"})
        @ExecuteOn(value="blocking")
        public void requestFilterContinuationUpdateRequest(FilterContinuation<HttpResponse<?>> continuation) {
            continuation.request((HttpRequest)HttpRequest.GET((String)"/request-filter/continuation-update-request-2"));
            continuation.proceed();
        }

        @RequestFilter(value={"/request-filter/immediate-response"})
        public HttpResponse<?> requestFilterImmediateResponse() {
            return HttpResponse.ok((Object)"requestFilterImmediateResponse");
        }

        @RequestFilter(value={"/request-filter/null-response"})
        public @Nullable HttpResponse<?> requestFilterNullResponse() {
            this.events.add("requestFilterNullResponse");
            return null;
        }

        @RequestFilter(value={"/request-filter/empty-optional-response"})
        public Optional<HttpResponse<?>> requestFilterEmptyOptionalResponse() {
            this.events.add("requestFilterEmptyOptionalResponse");
            return Optional.empty();
        }

        @RequestFilter(value={"/request-filter/publisher-response"})
        public Publisher<HttpResponse<?>> requestFilterPublisherResponse() {
            return Mono.fromCallable(() -> HttpResponse.ok((Object)"requestFilterPublisherResponse"));
        }

        @RequestFilter(value={"/request-filter/mono-response"})
        public Mono<HttpResponse<?>> requestFilterMonoResponse() {
            return Mono.fromCallable(() -> HttpResponse.ok((Object)"requestFilterMonoResponse"));
        }

        @RequestFilter(value={"/request-filter/completable-response"})
        public CompletableFuture<MutableHttpResponse<String>> requestFilterCompletableResponse() {
            return CompletableFuture.completedFuture(HttpResponse.ok((Object)"requestFilterCompletableResponse"));
        }

        @RequestFilter(value={"/request-filter/completion-response"})
        public CompletionStage<MutableHttpResponse<String>> requestFilterCompletionResponse() {
            return CompletableFuture.completedStage(HttpResponse.ok((Object)"requestFilterCompletionResponse"));
        }
    }

    @Controller
    @Requires(property="spec.name", value="ClientRequestFilterTest")
    public static class MyController {
        @Get(value="/request-filter/immediate-request-parameter")
        public String requestFilterImmediateRequestParameter() {
            return "foo";
        }

        @Get(value="/request-filter/immediate-mutable-request-parameter")
        public String requestFilterImmediateMutableRequestParameter(HttpRequest<?> request) {
            return (String)request.getHeaders().get((CharSequence)"foo");
        }

        @Get(value="/request-filter/replace-request-2")
        public String requestFilterReplaceRequest(HttpRequest<?> request) {
            return request.getPath();
        }

        @Get(value="/request-filter/replace-mutable-request-2")
        public String requestFilterReplaceMutableRequest(HttpRequest<?> request) {
            return request.getPath();
        }

        @Get(value="/request-filter/replace-request-null")
        public String requestFilterReplaceRequestNull(HttpRequest<?> request) {
            return request.getPath();
        }

        @Get(value="/request-filter/replace-request-empty")
        public String requestFilterReplaceRequestEmpty(HttpRequest<?> request) {
            return request.getPath();
        }

        @Get(value="/request-filter/replace-request-publisher-2")
        public String requestFilterReplaceRequestPublisher(HttpRequest<?> request) {
            return request.getPath();
        }

        @Get(value="/request-filter/replace-request-mono-2")
        public String requestFilterReplaceRequestMono(HttpRequest<?> request) {
            return request.getPath();
        }

        @Get(value="/request-filter/replace-request-completable-2")
        public String requestFilterReplaceRequestCompletable(HttpRequest<?> request) {
            return request.getPath();
        }

        @Get(value="/request-filter/replace-request-completion-2")
        public String requestFilterReplaceRequestCompletion(HttpRequest<?> request) {
            return request.getPath();
        }

        @Get(value="/request-filter/continuation-blocking")
        public String requestFilterContinuationBlocking(HttpRequest<?> request) {
            return (String)request.getHeaders().get((CharSequence)"foo");
        }

        @Get(value="/request-filter/continuation-reactive-publisher")
        public String requestFilterContinuationReactivePublisher(HttpRequest<?> request) {
            return (String)request.getHeaders().get((CharSequence)"foo");
        }

        @Get(value="/request-filter/continuation-update-request")
        public String requestFilterContinuationUpdateRequest(HttpRequest<?> request) {
            return request.getPath();
        }

        @Get(value="/request-filter/null-response")
        public String requestFilterNullResponse(HttpRequest<?> request) {
            return "foo";
        }

        @Get(value="/request-filter/empty-optional-response")
        public String requestFilterEmptyOptionalResponse(HttpRequest<?> request) {
            return "foo";
        }
    }
}

