/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.tck.tests;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.io.buffer.ReferenceCounted;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.client.StreamingHttpClient;
import io.micronaut.http.tck.TestScenario;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

class StreamTest {
    private static final String SPEC_NAME = "StreamTest";
    private static final int REPS = 1000;

    StreamTest() {
    }

    @Test
    void dataStreamRelease() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, Map.of(), (HttpRequest)HttpRequest.GET((String)"/encoding/bytes"), (server, request) -> {
            try (StreamingHttpClient client = (StreamingHttpClient)server.getApplicationContext().createBean(StreamingHttpClient.class, new Object[]{server.getURL().orElseThrow()});){
                List arrays = (List)Flux.from((Publisher)client.dataStream(request)).map(bb -> {
                    byte[] arr = bb.toByteArray();
                    if (bb instanceof ReferenceCounted) {
                        ReferenceCounted rc = (ReferenceCounted)bb;
                        rc.release();
                    }
                    return arr;
                }).collectList().block();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                for (byte[] array : arrays) {
                    baos.writeBytes(array);
                }
                Assertions.assertEquals((Object)"foo".repeat(1000), (Object)baos.toString(StandardCharsets.UTF_8));
            }
        });
    }

    @Requires(property="spec.name", value="StreamTest")
    @Controller(value="/encoding")
    static class StreamingController {
        StreamingController() {
        }

        @Get(value="/bytes")
        Flux<byte[]> bytes() {
            return Flux.fromStream(IntStream.range(0, 1000).mapToObj(i -> "foo".getBytes(StandardCharsets.UTF_8)));
        }
    }
}

