/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.tck.tests;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.io.buffer.ByteArrayBufferFactory;
import io.micronaut.core.io.buffer.ByteBufferFactory;
import io.micronaut.http.ByteBodyHttpResponse;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.ClientFilter;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.RequestFilter;
import io.micronaut.http.annotation.ResponseFilter;
import io.micronaut.http.body.ByteBodyFactory;
import io.micronaut.http.body.CloseableAvailableByteBody;
import io.micronaut.http.body.CloseableByteBody;
import io.micronaut.http.body.stream.AvailableByteArrayBody;
import io.micronaut.http.body.stream.InputStreamByteBody;
import io.micronaut.http.client.RawHttpClient;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.http.tck.ServerUnderTestProviderUtils;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.scheduling.annotation.ExecuteOn;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.OptionalLong;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadLocalRandom;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

class RawTest {
    public static final String SPEC_NAME = "RawTest";
    private static final byte[] LONG_PAYLOAD = new byte[0x100000];

    RawTest() {
    }

    @Test
    public void getLong() throws Exception {
        try (ServerUnderTest server = ServerUnderTestProviderUtils.getServerUnderTestProvider().getServer(SPEC_NAME);
             RawHttpClient client = (RawHttpClient)server.getApplicationContext().createBean(RawHttpClient.class);
             ByteBodyHttpResponse response = (ByteBodyHttpResponse)Mono.from((Publisher)client.exchange((HttpRequest)HttpRequest.GET((String)(String.valueOf(server.getURL().get()) + "/raw/get-long")), null, null)).cast(ByteBodyHttpResponse.class).block();){
            Assertions.assertArrayEquals((byte[])LONG_PAYLOAD, (byte[])((CloseableAvailableByteBody)response.byteBody().buffer().get()).toByteArray());
        }
    }

    @Test
    public void getLongInputStream() throws Exception {
        try (ServerUnderTest server = ServerUnderTestProviderUtils.getServerUnderTestProvider().getServer(SPEC_NAME);
             RawHttpClient client = (RawHttpClient)server.getApplicationContext().createBean(RawHttpClient.class);
             ByteBodyHttpResponse response = (ByteBodyHttpResponse)Mono.from((Publisher)client.exchange((HttpRequest)HttpRequest.GET((String)(String.valueOf(server.getURL().get()) + "/raw/get-long")), null, null)).cast(ByteBodyHttpResponse.class).block();
             InputStream is = response.byteBody().toInputStream();){
            Assertions.assertArrayEquals((byte[])LONG_PAYLOAD, (byte[])is.readAllBytes());
        }
    }

    @Test
    public void echoLong() throws Exception {
        try (ServerUnderTest server = ServerUnderTestProviderUtils.getServerUnderTestProvider().getServer(SPEC_NAME);
             RawHttpClient client = (RawHttpClient)server.getApplicationContext().createBean(RawHttpClient.class);
             ByteBodyHttpResponse response = (ByteBodyHttpResponse)Mono.from((Publisher)client.exchange((HttpRequest)HttpRequest.POST((String)(String.valueOf(server.getURL().get()) + "/raw/echo"), null), (CloseableByteBody)AvailableByteArrayBody.create((ByteBufferFactory)ByteArrayBufferFactory.INSTANCE, (byte[])LONG_PAYLOAD), null)).cast(ByteBodyHttpResponse.class).block();){
            Assertions.assertArrayEquals((byte[])LONG_PAYLOAD, (byte[])((CloseableAvailableByteBody)response.byteBody().buffer().get()).toByteArray());
        }
    }

    @Test
    public void echoLongInputStream() throws Exception {
        try (ServerUnderTest server = ServerUnderTestProviderUtils.getServerUnderTestProvider().getServer(SPEC_NAME);
             RawHttpClient client = (RawHttpClient)server.getApplicationContext().createBean(RawHttpClient.class);
             ByteBodyHttpResponse response = (ByteBodyHttpResponse)Mono.from((Publisher)client.exchange((HttpRequest)HttpRequest.POST((String)(String.valueOf(server.getURL().get()) + "/raw/echo"), null), InputStreamByteBody.create((InputStream)new ByteArrayInputStream(LONG_PAYLOAD), (OptionalLong)OptionalLong.of(LONG_PAYLOAD.length), (Executor)((Executor)server.getApplicationContext().getBean(Executor.class, Qualifiers.byName((String)"blocking"))), (ByteBodyFactory)ByteBodyFactory.createDefault((ByteBufferFactory)ByteArrayBufferFactory.INSTANCE)), null)).cast(ByteBodyHttpResponse.class).block();){
            Assertions.assertArrayEquals((byte[])LONG_PAYLOAD, (byte[])((CloseableAvailableByteBody)response.byteBody().buffer().get()).toByteArray());
        }
    }

    @Test
    public void httpClientFactory() throws Exception {
        try (ServerUnderTest server = ServerUnderTestProviderUtils.getServerUnderTestProvider().getServer(SPEC_NAME);
             RawHttpClient client = RawHttpClient.create(null);
             ByteBodyHttpResponse response = (ByteBodyHttpResponse)Mono.from((Publisher)client.exchange((HttpRequest)HttpRequest.GET((String)(String.valueOf(server.getURL().get()) + "/raw/get-long")), null, null)).cast(ByteBodyHttpResponse.class).block();){
            Assertions.assertArrayEquals((byte[])LONG_PAYLOAD, (byte[])((CloseableAvailableByteBody)response.byteBody().buffer().get()).toByteArray());
        }
    }

    @Test
    public void filterRequestReplaceResponse() throws Exception {
        try (ServerUnderTest server = ServerUnderTestProviderUtils.getServerUnderTestProvider().getServer(SPEC_NAME);
             RawHttpClient client = (RawHttpClient)server.getApplicationContext().createBean(RawHttpClient.class);){
            HttpResponse response = (HttpResponse)Mono.from((Publisher)client.exchange((HttpRequest)HttpRequest.POST((String)(String.valueOf(server.getURL().get()) + "/raw/filter-request-replace-response"), null), (CloseableByteBody)AvailableByteArrayBody.create((ByteBufferFactory)ByteArrayBufferFactory.INSTANCE, (byte[])"foo".getBytes(StandardCharsets.UTF_8)), null)).block();
            Assertions.assertFalse((boolean)(response instanceof ByteBodyHttpResponse));
            Assertions.assertEquals((Object)"Replaced response. Request body: foo", response.getBody(String.class).get());
        }
    }

    @Test
    public void filterReplaceResponse() throws Exception {
        try (ServerUnderTest server = ServerUnderTestProviderUtils.getServerUnderTestProvider().getServer(SPEC_NAME);
             RawHttpClient client = (RawHttpClient)server.getApplicationContext().createBean(RawHttpClient.class);){
            HttpResponse response = (HttpResponse)Mono.from((Publisher)client.exchange((HttpRequest)HttpRequest.GET((String)(String.valueOf(server.getURL().get()) + "/raw/filter-replace-response")), null, null)).block();
            Assertions.assertFalse((boolean)(response instanceof ByteBodyHttpResponse));
            Assertions.assertEquals((Object)"Replaced response. Response body: bar", response.getBody(String.class).get());
        }
    }

    @Test
    public void redirect() throws Exception {
        try (ServerUnderTest server = ServerUnderTestProviderUtils.getServerUnderTestProvider().getServer(SPEC_NAME);
             RawHttpClient client = (RawHttpClient)server.getApplicationContext().createBean(RawHttpClient.class);
             ByteBodyHttpResponse response = (ByteBodyHttpResponse)Mono.from((Publisher)client.exchange((HttpRequest)HttpRequest.GET((String)(String.valueOf(server.getURL().get()) + "/raw/redirect-from")), null, null)).cast(ByteBodyHttpResponse.class).block();){
            Assertions.assertEquals((Object)"redirect successful", (Object)((CloseableAvailableByteBody)response.byteBody().buffer().get()).toString(StandardCharsets.UTF_8));
        }
    }

    static {
        ThreadLocalRandom.current().nextBytes(LONG_PAYLOAD);
    }

    @ClientFilter(value={"/raw"})
    @Requires(property="spec.name", value="RawTest")
    static class RawFilter {
        RawFilter() {
        }

        @RequestFilter(value={"/filter-request-replace-response"})
        public HttpResponse<?> filterRequestReplaceResponse(HttpRequest<?> request, @Body String body) throws Exception {
            return HttpResponse.ok((Object)("Replaced response. Request body: " + body));
        }

        @ResponseFilter(value={"/filter-replace-response"})
        @ExecuteOn(value="blocking")
        public HttpResponse<?> filterReplaceResponse(HttpResponse<?> response) throws Exception {
            try (ByteBodyHttpResponse r = (ByteBodyHttpResponse)response;){
                MutableHttpResponse mutableHttpResponse = HttpResponse.ok((Object)("Replaced response. Response body: " + ((CloseableAvailableByteBody)r.byteBody().buffer().get()).toString(StandardCharsets.UTF_8)));
                return mutableHttpResponse;
            }
        }
    }

    @Controller(value="/raw")
    @Requires(property="spec.name", value="RawTest")
    static class RawController {
        RawController() {
        }

        @Get(value="/get-long")
        public InputStream getLong() {
            return new ByteArrayInputStream(LONG_PAYLOAD);
        }

        @Post(value="/echo")
        public InputStream echo(@Body InputStream body) throws IOException {
            return body;
        }

        @Get(value="/filter-replace-response")
        public String filterReplaceResponse() {
            return "bar";
        }

        @Get(value="/redirect-from")
        public HttpResponse<?> redirectFrom() {
            return HttpResponse.redirect((URI)URI.create("/raw/redirect-to"));
        }

        @Get(value="/redirect-to")
        public String redirectTo() {
            return "redirect successful";
        }
    }
}

