/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.tck.tests;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.client.tck.tests.Person;
import io.micronaut.http.tck.AssertionUtils;
import io.micronaut.http.tck.HttpResponseAssertion;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.http.tck.TestScenario;
import java.io.IOException;
import java.util.Map;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class HttpMethodPostTest {
    private static final String SPEC_NAME = "HttpMethodPostTest";

    HttpMethodPostTest() {
    }

    @ParameterizedTest(name="blocking={0}")
    @ValueSource(booleans={true, false})
    void postBody(boolean blocking) throws IOException {
        TestScenario.asserts((String)SPEC_NAME, Map.of("use.blocking.client", blocking), (HttpRequest)HttpRequest.POST((String)"/post/object-body", (Object)new Person("Tim", 49)), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("Tim:49").build()));
    }

    @Requires(property="spec.name", value="HttpMethodPostTest")
    @Controller(value="/post")
    static class HttpMethodPostTestController {
        HttpMethodPostTestController() {
        }

        @Post
        String response() {
            return "ok";
        }

        @Post(value="/object-body")
        String person(@Body Person person) {
            return person.getName() + ":" + person.getAge();
        }
    }
}

