/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.tck.tests;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Delete;
import io.micronaut.http.annotation.Status;
import io.micronaut.http.client.annotation.Client;
import io.micronaut.http.client.tck.tests.Person;
import io.micronaut.http.tck.AssertionUtils;
import io.micronaut.http.tck.BodyAssertion;
import io.micronaut.http.tck.HttpResponseAssertion;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.http.tck.ServerUnderTestProviderUtils;
import io.micronaut.http.tck.TestScenario;
import java.io.IOException;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class HttpMethodDeleteTest {
    private static final String SPEC_NAME = "HttpMethodDeleteTest";

    HttpMethodDeleteTest() {
    }

    @ParameterizedTest(name="blocking={0}")
    @ValueSource(booleans={true, false})
    void deleteMethodMapping(boolean blocking) throws IOException {
        TestScenario.asserts((String)SPEC_NAME, Map.of("use.blocking.client", blocking), (HttpRequest)HttpRequest.DELETE((String)"/delete"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.NO_CONTENT).build()));
    }

    @Test
    void deleteMethodClientMappingWithStringResponse() throws IOException {
        try (ServerUnderTest server = ServerUnderTestProviderUtils.getServerUnderTestProvider().getServer(SPEC_NAME);){
            HttpMethodDeleteClient client = (HttpMethodDeleteClient)server.getApplicationContext().getBean(HttpMethodDeleteClient.class);
            Assertions.assertEquals((Object)"ok", (Object)client.response());
        }
    }

    @ParameterizedTest(name="blocking={0}")
    @ValueSource(booleans={true, false})
    void deleteMethodMappingWithStringResponse(boolean blocking) throws IOException {
        TestScenario.asserts((String)SPEC_NAME, Map.of("use.blocking.client", blocking), (HttpRequest)HttpRequest.DELETE((String)"/delete/string-response"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("ok").build()));
    }

    @ParameterizedTest(name="blocking={0}")
    @ValueSource(booleans={true, false})
    void deleteMethodMappingWithObjectResponse(boolean blocking) throws IOException {
        TestScenario.asserts((String)SPEC_NAME, Map.of("use.blocking.client", blocking), (HttpRequest)HttpRequest.DELETE((String)"/delete/object-response"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body(BodyAssertion.builder().body("{\"name\":\"Tim\",\"age\":49}").equals()).build()));
    }

    @ParameterizedTest(name="blocking={0}")
    @ValueSource(booleans={true, false})
    void deleteMethodMappingWithRequestBody(boolean blocking) throws IOException {
        TestScenario.asserts((String)SPEC_NAME, Map.of("use.blocking.client", blocking), (HttpRequest)HttpRequest.DELETE((String)"/delete/echo").body((Object)"{\"foo\":\"bar\"}"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body(BodyAssertion.builder().body("{\"foo\":\"bar\"}").equals()).build()));
    }

    @Requires(property="spec.name", value="HttpMethodDeleteTest")
    @Client(value="/delete")
    static interface HttpMethodDeleteClient {
        public HttpResponse<Void> index();

        @Delete(value="/string-response")
        public String response();

        @Delete(value="/object-response")
        public Person person();
    }

    @Requires(property="spec.name", value="HttpMethodDeleteTest")
    @Controller(value="/delete")
    static class HttpMethodDeleteTestController {
        HttpMethodDeleteTestController() {
        }

        @Delete
        @Status(value=HttpStatus.NO_CONTENT)
        void index() {
        }

        @Delete(value="/string-response")
        String response() {
            return "ok";
        }

        @Delete(value="/object-response")
        Person person() {
            return new Person("Tim", 49);
        }

        @Delete(value="/echo")
        String echo(@Body String body) {
            return body;
        }
    }
}

