/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.tck.tests;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Header;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.http.tck.ServerUnderTestProviderUtils;
import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class HeadersTest {
    public static final String SPEC_NAME = "HeadersTest";

    @Test
    void testHeaders() throws IOException {
        try (ServerUnderTest server = ServerUnderTestProviderUtils.getServerUnderTestProvider().getServer(SPEC_NAME);){
            Client client = (Client)server.getApplicationContext().getBean(Client.class);
            Assertions.assertEquals((Object)"{\"status\":\"ok\"}", (Object)client.getOkAsJson());
            Assertions.assertEquals((Object)"{\"status\":\"okok\"}", (Object)client.getFooAsJson("fOO", "ok"));
            Assertions.assertEquals((Object)"{\"status\":\"okok\"}", (Object)client.getFooAsJson2("fOO", "ok"));
        }
    }

    @Requires(property="spec.name", value="HeadersTest")
    @io.micronaut.http.client.annotation.Client(value="/foo")
    static interface Client
    extends API {
    }

    static interface API {
        @Get(value="/ok", produces={"application/json"})
        public String getOkAsJson();

        @Get(value="/bar", produces={"application/json"})
        public String getFooAsJson(@Header(value="Foo") String var1, @Header(value="fOo") String var2);

        @Get(value="/bar2", produces={"application/json"})
        public String getFooAsJson2(@Header(name="Foo") String var1, @Header(name="fOo") String var2);
    }

    @Controller(value="/foo")
    @Requires(property="spec.name", value="HeadersTest")
    static class ProduceController
    implements API {
        ProduceController() {
        }

        @Override
        @Get(value="/ok", produces={"application/json"})
        public String getOkAsJson() {
            return "{\"status\":\"ok\"}";
        }

        @Override
        @Get(value="/bar", produces={"application/json"})
        public String getFooAsJson(@Header(value="Foo") String header1, @Header(value="fOo") String header2) {
            return "{\"status\":\"" + header1 + header2 + "\"}";
        }

        @Override
        @Get(value="/bar2", produces={"application/json"})
        public String getFooAsJson2(@Header(name="Foo") String header1, @Header(name="fOo") String header2) {
            return "{\"status\":\"" + header1 + header2 + "\"}";
        }
    }
}

