/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.tck.tests;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.tck.AssertionUtils;
import io.micronaut.http.tck.HttpResponseAssertion;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.http.tck.TestScenario;
import java.io.IOException;
import java.util.Map;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class ExceptionOnErrorStatusTest {
    private static final String SPEC_NAME = "ExceptionOnErrorStatusTest";

    ExceptionOnErrorStatusTest() {
    }

    @ParameterizedTest(name="blocking={0}")
    @ValueSource(booleans={true, false})
    void exceptionOnErrorStatus(boolean blocking) throws IOException {
        TestScenario.asserts((String)SPEC_NAME, Map.of("micronaut.http.client.exception-on-error-status", "false", "use.blocking.client", blocking), (HttpRequest)HttpRequest.GET((String)"/unprocessable"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.UNPROCESSABLE_ENTITY).body("{\"message\":\"Cannot make it\"}").build()));
    }

    @Requires(property="spec.name", value="ExceptionOnErrorStatusTest")
    @Controller(value="/unprocessable")
    static class RedirectTestController {
        RedirectTestController() {
        }

        @Get
        HttpResponse<?> index() {
            return HttpResponse.unprocessableEntity().body((Object)"{\"message\":\"Cannot make it\"}");
        }
    }
}

