/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.tck.tests;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.tck.AssertionUtils;
import io.micronaut.http.tck.HttpResponseAssertion;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.http.tck.TestScenario;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class EncodingTest {
    private static final String SPEC_NAME = "EncodingTest";

    EncodingTest() {
    }

    @Test
    void bytesDecodedCorrectly() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, Map.of(), (HttpRequest)HttpRequest.GET((String)"/encoding/bytes"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).assertResponse(response -> Assertions.assertEquals((Object)"foo", response.getBody(String.class).get())).build()));
    }

    @Test
    void stringDecodedCorrectly() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, Map.of(), (HttpRequest)HttpRequest.GET((String)"/encoding/string"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).assertResponse(response -> Assertions.assertEquals((Object)"foo", response.getBody(String.class).get())).build()));
    }

    @Requires(property="spec.name", value="EncodingTest")
    @Controller(value="/encoding")
    static class EncodingTestController {
        EncodingTestController() {
        }

        @Get(value="/bytes")
        @Produces(value={"text/plain; charset=utf-16"})
        byte[] bytes() {
            return "foo".getBytes(StandardCharsets.UTF_16);
        }

        @Get(value="/string")
        @Produces(value={"text/plain; charset=utf-16"})
        String string() {
            return "foo";
        }
    }
}

