/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.tck.tests;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.tck.AssertionUtils;
import io.micronaut.http.tck.HttpResponseAssertion;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.http.tck.TestScenario;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class DontFollowRedirectsTest {
    private static final String SPEC_NAME = "DisableRedirectTest";

    DontFollowRedirectsTest() {
    }

    @ParameterizedTest(name="blocking={0}")
    @ValueSource(booleans={true, false})
    void dontFollowRedirects(boolean blocking) throws IOException {
        TestScenario.asserts((String)SPEC_NAME, Map.of("micronaut.http.client.follow-redirects", "false", "use.blocking.client", blocking), (HttpRequest)HttpRequest.GET((String)"/redirect/redirect"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.SEE_OTHER).assertResponse(response -> {
            Assertions.assertNotNull((Object)response.getHeaders().get((CharSequence)"Location"));
            Assertions.assertEquals((Object)"/redirect/direct", (Object)response.getHeaders().get((CharSequence)"Location"));
        }).build()));
    }

    @Requires(property="spec.name", value="DisableRedirectTest")
    @Controller(value="/redirect")
    static class RedirectTestController {
        RedirectTestController() {
        }

        @Get(value="/redirect")
        HttpResponse<?> redirect() {
            return HttpResponse.seeOther((URI)URI.create("/redirect/direct"));
        }
    }
}

