/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.tck.tests;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.ByteBodyHttpResponse;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.body.CloseableAvailableByteBody;
import io.micronaut.http.client.RawHttpClient;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.http.tck.ServerUnderTestProviderUtils;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

class DecompressionConfigTest {
    static final String SPEC_NAME = "DecompressionConfigTest";
    private static final byte[] UNCOMPRESSED = "Hello, gzip!".getBytes(StandardCharsets.UTF_8);
    private static final byte[] GZIPPED = DecompressionConfigTest.gzip(UNCOMPRESSED);

    DecompressionConfigTest() {
    }

    @Test
    void gzipPreservedWhenDecompressionDisabled() throws Exception {
        try (ServerUnderTest server = ServerUnderTestProviderUtils.getServerUnderTestProvider().getServer(SPEC_NAME, Map.of("micronaut.http.client.decompression-enabled", "false"));
             RawHttpClient client = (RawHttpClient)server.getApplicationContext().createBean(RawHttpClient.class);
             ByteBodyHttpResponse response = (ByteBodyHttpResponse)Mono.from((Publisher)client.exchange((HttpRequest)HttpRequest.GET((String)(String.valueOf(server.getURL().get()) + "/decompression/gzip")), null, null)).cast(ByteBodyHttpResponse.class).block();){
            byte[] body = ((CloseableAvailableByteBody)response.byteBody().buffer().get()).toByteArray();
            Assertions.assertArrayEquals((byte[])GZIPPED, (byte[])body);
            Assertions.assertEquals((Object)"gzip", (Object)response.getHeaders().get((CharSequence)"Content-Encoding"));
        }
    }

    @Test
    void gzipIsDecompressedByDefault() throws Exception {
        try (ServerUnderTest server = ServerUnderTestProviderUtils.getServerUnderTestProvider().getServer(SPEC_NAME);
             RawHttpClient client = (RawHttpClient)server.getApplicationContext().createBean(RawHttpClient.class);
             ByteBodyHttpResponse response = (ByteBodyHttpResponse)Mono.from((Publisher)client.exchange((HttpRequest)HttpRequest.GET((String)(String.valueOf(server.getURL().get()) + "/decompression/gzip")), null, null)).cast(ByteBodyHttpResponse.class).block();){
            byte[] body = ((CloseableAvailableByteBody)response.byteBody().buffer().get()).toByteArray();
            Assertions.assertArrayEquals((byte[])UNCOMPRESSED, (byte[])body);
            Assertions.assertFalse((boolean)response.getHeaders().contains("Content-Encoding"));
        }
    }

    private static byte[] gzip(byte[] data) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (GZIPOutputStream gzip = new GZIPOutputStream(baos);){
                gzip.write(data);
            }
            return baos.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Controller(value="/decompression")
    @Requires(property="spec.name", value="DecompressionConfigTest")
    static class DecompressionController {
        DecompressionController() {
        }

        @Get(value="/gzip")
        HttpResponse<byte[]> gzip() {
            return HttpResponse.ok((Object)GZIPPED).header((CharSequence)"Content-Encoding", (CharSequence)"gzip").contentLength((long)GZIPPED.length);
        }
    }
}

