/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.tck.tests;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.CookieValue;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.http.tck.AssertionUtils;
import io.micronaut.http.tck.BodyAssertion;
import io.micronaut.http.tck.HttpResponseAssertion;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.http.tck.TestScenario;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class CookieTest {
    private static final String SPEC_NAME = "CookieTest";

    CookieTest() {
    }

    @ParameterizedTest(name="blocking={0}")
    @ValueSource(booleans={true, false})
    void cookieBinding(boolean blocking) throws IOException {
        TestScenario.asserts((String)SPEC_NAME, Map.of("use.blocking.client", blocking), (HttpRequest)HttpRequest.GET((String)"/cookies-test/bind").cookie(Cookie.of((String)"one", (String)"foo")).cookie(Cookie.of((String)"two", (String)"bar")), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body(BodyAssertion.builder().body("{\"one\":\"foo\",\"two\":\"bar\"}").equals()).build()));
    }

    @ParameterizedTest(name="blocking={0}")
    @ValueSource(booleans={true, false})
    void getCookiesFromRequest(boolean blocking) throws IOException {
        TestScenario.asserts((String)SPEC_NAME, Map.of("use.blocking.client", blocking), (HttpRequest)HttpRequest.GET((String)"/cookies-test/all").cookie(Cookie.of((String)"one", (String)"foo")).cookie(Cookie.of((String)"two", (String)"bar")), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body(BodyAssertion.builder().body("{\"one\":\"foo\",\"two\":\"bar\"}").equals()).build()));
    }

    @ParameterizedTest(name="blocking={0}")
    @ValueSource(booleans={true, false})
    void testNoCookies(boolean blocking) throws IOException {
        TestScenario.asserts((String)SPEC_NAME, Map.of("use.blocking.client", blocking), (HttpRequest)HttpRequest.GET((String)"/cookies-test/all"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body(BodyAssertion.builder().body("{}").equals()).build()));
    }

    @Controller(value="/cookies-test")
    @Requires(property="spec.name", value="CookieTest")
    static class CookieController {
        CookieController() {
        }

        @Get(uri="/all")
        Map<String, String> all(HttpRequest<?> request) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (String cookieName : request.getCookies().names()) {
                map.put(cookieName, request.getCookies().get((CharSequence)cookieName).getValue());
            }
            return map;
        }

        @Get(uri="/bind")
        Map<String, String> all(@CookieValue String one, @CookieValue String two) {
            return CollectionUtils.mapOf((Object[])new Object[]{"one", one, "two", two});
        }
    }
}

