/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.tck.tests;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Part;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.client.multipart.MultipartBody;
import io.micronaut.http.tck.AssertionUtils;
import io.micronaut.http.tck.BodyAssertion;
import io.micronaut.http.tck.HttpResponseAssertion;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.http.tck.TestScenario;
import io.micronaut.scheduling.annotation.ExecuteOn;
import java.io.IOException;
import java.util.Map;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

class ContinueTest {
    private static final String SPEC_NAME = "ContinueTest";

    ContinueTest() {
    }

    @ParameterizedTest(name="blocking={0}")
    @ValueSource(booleans={true, false})
    public void testContinueFull(boolean blocking) throws IOException {
        TestScenario.asserts((String)SPEC_NAME, Map.of("use.blocking.client", blocking), (HttpRequest)HttpRequest.POST((String)"/continue/plain", (Object)"1").header((CharSequence)"Expect", (CharSequence)"100-continue"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body(BodyAssertion.builder().body("1").equals()).build()));
    }

    @ParameterizedTest(name="blocking={0}")
    @ValueSource(booleans={true, false})
    public void testContinuePublisher(boolean blocking) throws IOException {
        TestScenario.asserts((String)SPEC_NAME, Map.of("use.blocking.client", blocking), (HttpRequest)HttpRequest.POST((String)"/continue/plain", (Object)Flux.just((Object[])new String[]{"1", "2"})).header((CharSequence)"Expect", (CharSequence)"100-continue"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body(BodyAssertion.builder().body("[1,2]").equals()).build()));
    }

    @Tag(value="multipart")
    @ParameterizedTest(name="blocking={0}")
    @ValueSource(booleans={true, false})
    public void testContinueMultipart(boolean blocking) throws IOException {
        TestScenario.asserts((String)SPEC_NAME, Map.of("use.blocking.client", blocking), (HttpRequest)HttpRequest.POST((String)"/continue/part", (Object)MultipartBody.builder().addPart("foo", "bar").build()).header((CharSequence)"Expect", (CharSequence)"100-continue").contentType((CharSequence)"multipart/form-data"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body(BodyAssertion.builder().body("bar").equals()).build()));
    }

    @ParameterizedTest(name="blocking={0}")
    @ValueSource(booleans={true, false})
    public void testContinueFormEncoded(boolean blocking) throws IOException {
        TestScenario.asserts((String)SPEC_NAME, Map.of("use.blocking.client", blocking), (HttpRequest)HttpRequest.POST((String)"/continue/part", Map.of("foo", "bar")).header((CharSequence)"Expect", (CharSequence)"100-continue").contentType((CharSequence)"application/x-www-form-urlencoded"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body(BodyAssertion.builder().body("bar").equals()).build()));
    }

    @Controller(value="/continue")
    @Requires(property="spec.name", value="ContinueTest")
    public static class SimpleController {
        @Post(value="/plain")
        @ExecuteOn(value="blocking")
        public String plain(@Body Publisher<String> data) {
            return String.join((CharSequence)"", (Iterable)Flux.from(data).collectList().block());
        }

        @Post(value="/part")
        @Consumes(value={"multipart/form-data", "application/x-www-form-urlencoded"})
        public String part(@Part String foo) {
            return foo;
        }
    }
}

