/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.bind.binders;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.annotation.Header;
import io.micronaut.http.client.bind.AnnotatedClientRequestBinder;
import io.micronaut.http.client.bind.ClientRequestUriContext;
import java.util.List;
import org.jspecify.annotations.NonNull;

public class HeaderClientRequestBinder
implements AnnotatedClientRequestBinder<Header> {
    @Override
    public void bind(@NonNull MethodInvocationContext<Object, Object> context, @NonNull ClientRequestUriContext uriContext, @NonNull MutableHttpRequest<?> request) {
        List headerAnnotations = context.getAnnotationValuesByType(Header.class);
        for (AnnotationValue headerAnnotation : headerAnnotations) {
            String headerName = headerAnnotation.stringValue("name").orElse(null);
            String headerValue = headerAnnotation.stringValue().orElse(null);
            MutableHttpHeaders headers = request.getHeaders();
            if (!StringUtils.isNotEmpty((CharSequence)headerName) || !StringUtils.isNotEmpty((CharSequence)headerValue)) continue;
            headers.setIfMissing((CharSequence)headerName, (CharSequence)headerValue);
        }
    }

    @Override
    public @NonNull Class<Header> getAnnotationType() {
        return Header.class;
    }
}

