/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client;

import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.client.HttpClient;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.http.client.StreamingHttpClientFactoryResolver;
import java.net.URL;
import java.util.Map;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;

public interface StreamingHttpClient
extends HttpClient {
    public <I> Publisher<ByteBuffer<?>> dataStream(@NonNull HttpRequest<I> var1);

    public <I> Publisher<ByteBuffer<?>> dataStream(@NonNull HttpRequest<I> var1, @NonNull Argument<?> var2);

    public <I> Publisher<HttpResponse<ByteBuffer<?>>> exchangeStream(@NonNull HttpRequest<I> var1);

    public <I> Publisher<HttpResponse<ByteBuffer<?>>> exchangeStream(@NonNull HttpRequest<I> var1, @NonNull Argument<?> var2);

    public <I> Publisher<Map<String, Object>> jsonStream(@NonNull HttpRequest<I> var1);

    public <I, O> Publisher<O> jsonStream(@NonNull HttpRequest<I> var1, @NonNull Argument<O> var2);

    public <I, O> Publisher<O> jsonStream(@NonNull HttpRequest<I> var1, @NonNull Argument<O> var2, @NonNull Argument<?> var3);

    default public <I, O> Publisher<O> jsonStream(@NonNull HttpRequest<I> request, @NonNull Class<O> type) {
        return this.jsonStream(request, Argument.of(type));
    }

    public static StreamingHttpClient create(@Nullable URL url) {
        return StreamingHttpClientFactoryResolver.getFactory().createStreamingClient(url);
    }

    public static StreamingHttpClient create(@Nullable URL url, @NonNull HttpClientConfiguration configuration) {
        return StreamingHttpClientFactoryResolver.getFactory().createStreamingClient(url, configuration);
    }
}

