/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.Primary;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.http.ssl.ClientSslConfiguration;
import io.micronaut.http.ssl.SslConfiguration;
import io.micronaut.runtime.ApplicationConfiguration;
import jakarta.inject.Inject;

@ConfigurationProperties(value="micronaut.http.client")
@BootstrapContextCompatible
@Primary
public class DefaultHttpClientConfiguration
extends HttpClientConfiguration {
    public static final String PREFIX = "micronaut.http.client";
    private final DefaultConnectionPoolConfiguration connectionPoolConfiguration;
    private final DefaultWebSocketCompressionConfiguration webSocketCompressionConfiguration;
    private final DefaultHttp2ClientConfiguration http2Configuration;

    public DefaultHttpClientConfiguration() {
        this.connectionPoolConfiguration = new DefaultConnectionPoolConfiguration();
        this.webSocketCompressionConfiguration = new DefaultWebSocketCompressionConfiguration();
        this.http2Configuration = new DefaultHttp2ClientConfiguration();
    }

    @Deprecated(since="4.3.0")
    public DefaultHttpClientConfiguration(DefaultConnectionPoolConfiguration connectionPoolConfiguration, ApplicationConfiguration applicationConfiguration) {
        this(connectionPoolConfiguration, new DefaultWebSocketCompressionConfiguration(), applicationConfiguration);
    }

    @Deprecated(since="4.6.0")
    public DefaultHttpClientConfiguration(DefaultConnectionPoolConfiguration connectionPoolConfiguration, DefaultWebSocketCompressionConfiguration webSocketCompressionConfiguration, ApplicationConfiguration applicationConfiguration) {
        this(connectionPoolConfiguration, webSocketCompressionConfiguration, new DefaultHttp2ClientConfiguration(), applicationConfiguration);
    }

    @Inject
    public DefaultHttpClientConfiguration(DefaultConnectionPoolConfiguration connectionPoolConfiguration, DefaultWebSocketCompressionConfiguration webSocketCompressionConfiguration, DefaultHttp2ClientConfiguration http2Configuration, ApplicationConfiguration applicationConfiguration) {
        super(applicationConfiguration);
        this.connectionPoolConfiguration = connectionPoolConfiguration;
        this.webSocketCompressionConfiguration = webSocketCompressionConfiguration;
        this.http2Configuration = http2Configuration;
    }

    @Override
    public HttpClientConfiguration.ConnectionPoolConfiguration getConnectionPoolConfiguration() {
        return this.connectionPoolConfiguration;
    }

    @Override
    public HttpClientConfiguration.WebSocketCompressionConfiguration getWebSocketCompressionConfiguration() {
        return this.webSocketCompressionConfiguration;
    }

    @Inject
    public void setClientSslConfiguration(@Nullable ClientSslConfiguration sslConfiguration) {
        if (sslConfiguration != null) {
            super.setSslConfiguration((SslConfiguration)sslConfiguration);
        }
    }

    @Override
    public HttpClientConfiguration.Http2ClientConfiguration getHttp2Configuration() {
        return this.http2Configuration;
    }

    @ConfigurationProperties(value="pool")
    @BootstrapContextCompatible
    @Primary
    public static class DefaultConnectionPoolConfiguration
    extends HttpClientConfiguration.ConnectionPoolConfiguration {
    }

    @ConfigurationProperties(value="ws.compression")
    @BootstrapContextCompatible
    @Primary
    public static class DefaultWebSocketCompressionConfiguration
    extends HttpClientConfiguration.WebSocketCompressionConfiguration {
    }

    @ConfigurationProperties(value="http2")
    @BootstrapContextCompatible
    @Primary
    public static class DefaultHttp2ClientConfiguration
    extends HttpClientConfiguration.Http2ClientConfiguration {
    }
}

