/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client;

import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.ApplicationEventListener;
import io.micronaut.context.exceptions.DisabledBeanException;
import io.micronaut.core.annotation.Internal;
import io.micronaut.discovery.StaticServiceInstanceList;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.client.RxHttpClient;
import io.micronaut.http.client.RxHttpClientRegistry;
import io.micronaut.http.client.ServiceHttpClientCondition;
import io.micronaut.http.client.ServiceHttpClientConfiguration;
import io.micronaut.http.client.exceptions.HttpClientResponseException;
import io.micronaut.runtime.server.event.ServerStartupEvent;
import io.micronaut.scheduling.TaskScheduler;
import io.reactivex.Flowable;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.inject.Provider;

@Factory
@Internal
public class ServiceHttpClientFactory {
    private final TaskScheduler taskScheduler;
    private final Provider<RxHttpClientRegistry> clientFactory;

    public ServiceHttpClientFactory(TaskScheduler taskScheduler, Provider<RxHttpClientRegistry> clientFactory) {
        this.taskScheduler = taskScheduler;
        this.clientFactory = clientFactory;
    }

    @EachBean(value=ServiceHttpClientConfiguration.class)
    @Requires(condition=ServiceHttpClientCondition.class)
    StaticServiceInstanceList serviceInstanceList(ServiceHttpClientConfiguration configuration) {
        List<URI> originalURLs = configuration.getUrls();
        ConcurrentLinkedQueue<URI> loadBalancedURIs = new ConcurrentLinkedQueue<URI>(originalURLs);
        return new StaticServiceInstanceList(configuration.getServiceId(), loadBalancedURIs, (String)configuration.getPath().orElse(null));
    }

    @EachBean(value=ServiceHttpClientConfiguration.class)
    @Requires(condition=ServiceHttpClientCondition.class)
    ApplicationEventListener<ServerStartupEvent> healthCheckStarter(@Parameter ServiceHttpClientConfiguration configuration, @Parameter StaticServiceInstanceList instanceList) {
        if (configuration.isHealthCheck()) {
            return event -> {
                List<URI> originalURLs = configuration.getUrls();
                Collection loadBalancedURIs = instanceList.getLoadBalancedURIs();
                RxHttpClient httpClient = ((RxHttpClientRegistry)this.clientFactory.get()).getClient(configuration.getHttpVersion(), configuration.getServiceId(), configuration.getPath().orElse(null));
                this.taskScheduler.scheduleWithFixedDelay(configuration.getHealthCheckInterval(), configuration.getHealthCheckInterval(), () -> Flowable.fromIterable((Iterable)originalURLs).flatMap(originalURI -> {
                    URI healthCheckURI = originalURI.resolve(configuration.getHealthCheckUri());
                    return httpClient.exchange(HttpRequest.GET((URI)healthCheckURI)).onErrorResumeNext(throwable -> {
                        if (throwable instanceof HttpClientResponseException) {
                            HttpClientResponseException responseException = (HttpClientResponseException)((Object)((Object)((Object)((Object)((Object)throwable)))));
                            HttpResponse<?> response = responseException.getResponse();
                            return Flowable.just(response);
                        }
                        return Flowable.just((Object)HttpResponse.serverError());
                    }).map(response -> Collections.singletonMap(originalURI, response.getStatus()));
                }).subscribe(uriToStatusMap -> {
                    Map.Entry entry = uriToStatusMap.entrySet().iterator().next();
                    URI uri = (URI)entry.getKey();
                    HttpStatus status = (HttpStatus)entry.getValue();
                    if (status.getCode() >= 300) {
                        loadBalancedURIs.remove(uri);
                    } else if (!loadBalancedURIs.contains(uri)) {
                        loadBalancedURIs.add(uri);
                    }
                }));
            };
        }
        throw new DisabledBeanException("HTTP Client Health Check not enabled");
    }
}

