/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client;

import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.http.client.RxHttpClient;
import io.micronaut.http.client.StreamingHttpClient;
import io.reactivex.Flowable;
import java.net.URL;
import java.util.Map;

public interface RxStreamingHttpClient
extends StreamingHttpClient,
RxHttpClient {
    public <I> Flowable<ByteBuffer<?>> dataStream(HttpRequest<I> var1);

    public <I> Flowable<HttpResponse<ByteBuffer<?>>> exchangeStream(HttpRequest<I> var1);

    public <I> Flowable<Map<String, Object>> jsonStream(HttpRequest<I> var1);

    public <I, O> Flowable<O> jsonStream(HttpRequest<I> var1, Argument<O> var2);

    default public <I, O> Flowable<O> jsonStream(HttpRequest<I> request, Class<O> type) {
        return (Flowable)StreamingHttpClient.super.jsonStream(request, type);
    }

    public static RxStreamingHttpClient create(URL url) {
        return HttpClientConfiguration.createStreamingClient(url);
    }

    public static RxStreamingHttpClient create(URL url, HttpClientConfiguration configuration) {
        return HttpClientConfiguration.createStreamingClient(url, configuration);
    }
}

