/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.client.HttpClient;
import io.micronaut.http.client.HttpClientConfiguration;
import io.reactivex.Flowable;
import java.net.URL;

public interface RxHttpClient
extends HttpClient {
    default public <I, O> Flowable<HttpResponse<O>> exchange(HttpRequest<I> request, Argument<O> bodyType) {
        return Flowable.fromPublisher(HttpClient.super.exchange(request, bodyType));
    }

    public <I, O, E> Flowable<HttpResponse<O>> exchange(HttpRequest<I> var1, Argument<O> var2, Argument<E> var3);

    default public <I, O, E> Flowable<O> retrieve(HttpRequest<I> request, Argument<O> bodyType, Argument<E> errorType) {
        return Flowable.fromPublisher(HttpClient.super.retrieve(request, bodyType, errorType));
    }

    default public <I> Flowable<HttpResponse<ByteBuffer>> exchange(HttpRequest<I> request) {
        return Flowable.fromPublisher(HttpClient.super.exchange(request));
    }

    default public Flowable<HttpResponse<ByteBuffer>> exchange(String uri) {
        return Flowable.fromPublisher(HttpClient.super.exchange(uri));
    }

    default public <O> Flowable<HttpResponse<O>> exchange(String uri, Class<O> bodyType) {
        return Flowable.fromPublisher(HttpClient.super.exchange(uri, bodyType));
    }

    default public <I, O> Flowable<HttpResponse<O>> exchange(HttpRequest<I> request, Class<O> bodyType) {
        return Flowable.fromPublisher(HttpClient.super.exchange(request, bodyType));
    }

    default public <I, O> Flowable<O> retrieve(HttpRequest<I> request, Argument<O> bodyType) {
        return Flowable.fromPublisher(HttpClient.super.retrieve(request, bodyType));
    }

    default public <I, O> Flowable<O> retrieve(HttpRequest<I> request, Class<O> bodyType) {
        return this.retrieve(request, (Argument<O>)Argument.of(bodyType), (Argument<E>)DEFAULT_ERROR_TYPE);
    }

    default public <I> Flowable<String> retrieve(HttpRequest<I> request) {
        return this.retrieve(request, (Argument<O>)Argument.STRING, (Argument<E>)DEFAULT_ERROR_TYPE);
    }

    default public Flowable<String> retrieve(String uri) {
        return this.retrieve((HttpRequest<I>)((HttpRequest)HttpRequest.GET((String)uri)), (Argument<O>)Argument.STRING, (Argument<E>)DEFAULT_ERROR_TYPE);
    }

    public static RxHttpClient create(@Nullable URL url) {
        return HttpClientConfiguration.createClient(url);
    }
}

