/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.rxjava2;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Indexed;
import io.micronaut.core.annotation.Internal;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.client.ReactiveClientResultTransformer;
import io.micronaut.http.client.exceptions.HttpClientResponseException;
import io.reactivex.Flowable;
import io.reactivex.Maybe;
import javax.inject.Singleton;

@Singleton
@Requires(classes={Flowable.class})
@Internal
@Indexed(value=ReactiveClientResultTransformer.class)
public class RxReactiveClientResultTransformer
implements ReactiveClientResultTransformer {
    @Override
    public Object transform(Object publisherResult) {
        if (publisherResult instanceof Maybe) {
            Maybe maybe = (Maybe)publisherResult;
            return maybe.onErrorResumeNext(throwable -> {
                HttpClientResponseException responseException;
                if (throwable instanceof HttpClientResponseException && (responseException = (HttpClientResponseException)((Object)((Object)throwable))).getStatus() == HttpStatus.NOT_FOUND) {
                    return Maybe.empty();
                }
                return Maybe.error((Throwable)throwable);
            });
        }
        return publisherResult;
    }
}

