/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function.web;

import io.micronaut.context.ExecutionHandleLocator;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Value;
import io.micronaut.context.processor.ExecutableMethodProcessor;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.StringUtils;
import io.micronaut.function.DefaultLocalFunctionRegistry;
import io.micronaut.function.FunctionBean;
import io.micronaut.function.LocalFunctionRegistry;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.web.router.DefaultRouteBuilder;
import io.micronaut.web.router.RouteBuilder;
import io.micronaut.web.router.UriRoute;
import jakarta.inject.Singleton;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;

@Singleton
@Replaces(value=DefaultLocalFunctionRegistry.class)
public class AnnotatedFunctionRouteBuilder
extends DefaultRouteBuilder
implements ExecutableMethodProcessor<FunctionBean>,
LocalFunctionRegistry,
MediaTypeCodecRegistry {
    private final LocalFunctionRegistry localFunctionRegistry;
    private final String contextPath;
    private final Map<String, URI> availableFunctions = new ConcurrentHashMap<String, URI>();

    public AnnotatedFunctionRouteBuilder(ExecutionHandleLocator executionHandleLocator, RouteBuilder.UriNamingStrategy uriNamingStrategy, ConversionService conversionService, MediaTypeCodecRegistry codecRegistry, @Value(value="${micronaut.function.context-path:/}") String contextPath) {
        super(executionHandleLocator, uriNamingStrategy, conversionService);
        this.localFunctionRegistry = new DefaultLocalFunctionRegistry(codecRegistry);
        this.contextPath = contextPath.endsWith("/") ? contextPath : contextPath + "/";
    }

    public void process(BeanDefinition<?> beanDefinition, ExecutableMethod<?, ?> method) {
        if (beanDefinition.hasAnnotation(FunctionBean.class)) {
            Object argumentTypes;
            int argCount;
            String functionPath;
            String methodName = method.getMethodName();
            Class declaringType = method.getDeclaringType();
            String functionName = beanDefinition.stringValue(FunctionBean.class).orElse(methodName);
            String functionMethod = beanDefinition.stringValue(FunctionBean.class, "method").orElse(null);
            if (StringUtils.isNotEmpty((CharSequence)functionMethod) && !functionMethod.equals(methodName)) {
                return;
            }
            ArrayList<UriRoute> routes = new ArrayList<UriRoute>(2);
            MediaType[] consumes = (MediaType[])Arrays.stream(method.stringValues(Consumes.class)).map(MediaType::of).toArray(MediaType[]::new);
            MediaType[] produces = (MediaType[])Arrays.stream(method.stringValues(Produces.class)).map(MediaType::of).toArray(MediaType[]::new);
            boolean implementsFnInterface = false;
            if (Stream.of(Function.class, Consumer.class, BiFunction.class, BiConsumer.class).anyMatch(type -> type.isAssignableFrom(declaringType))) {
                implementsFnInterface = true;
                if (methodName.equals("accept") || methodName.equals("apply")) {
                    List typeArguments;
                    functionPath = this.resolveFunctionPath(methodName, declaringType, functionName);
                    String[] argumentNames = method.getArgumentNames();
                    String argumentName = argumentNames[0];
                    int argCount2 = argumentNames.length;
                    UriRoute route = this.POST(functionPath, beanDefinition, method);
                    routes.add(route);
                    if (argCount2 == 1) {
                        route.body(argumentName);
                    }
                    if (!(typeArguments = beanDefinition.getTypeArguments()).isEmpty()) {
                        Argument argument;
                        int size = typeArguments.size();
                        Argument firstArgument = (Argument)typeArguments.get(0);
                        if (size < 3 && ClassUtils.isJavaLangType((Class)firstArgument.getType()) && consumes.length == 0) {
                            consumes = new MediaType[]{MediaType.TEXT_PLAIN_TYPE, MediaType.APPLICATION_JSON_TYPE};
                        }
                        if (size < 3) {
                            route.body(Argument.of((Class)firstArgument.getType(), (String)argumentName));
                        }
                        if (size > 1 && ClassUtils.isJavaLangType((Class)(argument = (Argument)typeArguments.get(size == 3 ? 2 : 1)).getType()) && produces.length == 0) {
                            produces = new MediaType[]{MediaType.TEXT_PLAIN_TYPE, MediaType.APPLICATION_JSON_TYPE};
                        }
                    } else if (argCount2 == 1 && ClassUtils.isJavaLangType((Class)method.getArgumentTypes()[0]) && consumes.length == 0) {
                        consumes = new MediaType[]{MediaType.TEXT_PLAIN_TYPE, MediaType.APPLICATION_JSON_TYPE};
                    }
                }
            }
            if (routes.isEmpty() && Supplier.class.isAssignableFrom(declaringType)) {
                implementsFnInterface = true;
                if (methodName.equals("get")) {
                    functionPath = this.resolveFunctionPath(methodName, declaringType, functionName);
                    routes.add(this.GET(functionPath, beanDefinition, method));
                    routes.add(this.HEAD(functionPath, beanDefinition, method));
                }
            }
            if (routes.isEmpty() && (!implementsFnInterface || StringUtils.isNotEmpty((CharSequence)functionMethod)) && (argCount = ((Argument[])(argumentTypes = method.getArguments())).length) < 3) {
                String functionPath2 = this.resolveFunctionPath(methodName, declaringType, functionName);
                if (argCount == 0) {
                    routes.add(this.GET(functionPath2, beanDefinition, method));
                    routes.add(this.HEAD(functionPath2, beanDefinition, method));
                } else {
                    UriRoute route = this.POST(functionPath2, beanDefinition, method);
                    routes.add(route);
                    if (argCount != 2 && ClassUtils.isJavaLangType((Class)argumentTypes[0].getType())) {
                        route.body(method.getArgumentNames()[0]).consumesAll();
                    }
                }
            }
            if (!routes.isEmpty()) {
                for (UriRoute route : routes) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Created Route to Function: {}", (Object)route);
                    }
                    route.consumes(consumes);
                    route.produces(produces);
                }
                functionPath = this.resolveFunctionPath(methodName, declaringType, functionName);
                this.availableFunctions.put(functionName, URI.create(functionPath));
                ((ExecutableMethodProcessor)this.localFunctionRegistry).process(beanDefinition, method);
            }
        }
    }

    private String resolveFunctionPath(String methodName, Class<?> declaringType, String functionName) {
        String typeName;
        Object functionPath = functionName;
        functionPath = StringUtils.isEmpty((CharSequence)functionPath) ? ((typeName = declaringType.getSimpleName()).contains("$") ? this.contextPath + NameUtils.hyphenate((String)methodName) : this.contextPath + NameUtils.hyphenate((String)typeName)) : this.contextPath + (String)functionPath;
        return functionPath;
    }

    public Map<String, URI> getAvailableFunctions() {
        return Collections.unmodifiableMap(this.availableFunctions);
    }

    public <T, R> Optional<? extends ExecutableMethod<T, R>> findFirst() {
        return this.localFunctionRegistry.findFirst();
    }

    public <T, R> Optional<? extends ExecutableMethod<T, R>> find(String name) {
        return this.localFunctionRegistry.find(name);
    }

    public <T> Optional<ExecutableMethod<Supplier<T>, T>> findSupplier(String name) {
        return this.localFunctionRegistry.findSupplier(name);
    }

    public <T> Optional<ExecutableMethod<Consumer<T>, Void>> findConsumer(String name) {
        return this.localFunctionRegistry.findConsumer(name);
    }

    public <T, R> Optional<ExecutableMethod<Function<T, R>, R>> findFunction(String name) {
        return this.localFunctionRegistry.findFunction(name);
    }

    public <T, U, R> Optional<ExecutableMethod<BiFunction<T, U, R>, R>> findBiFunction(String name) {
        return this.localFunctionRegistry.findBiFunction(name);
    }

    public Optional<MediaTypeCodec> findCodec(@Nullable MediaType mediaType) {
        LocalFunctionRegistry localFunctionRegistry = this.localFunctionRegistry;
        if (localFunctionRegistry instanceof MediaTypeCodecRegistry) {
            MediaTypeCodecRegistry mediaTypeCodecRegistry = (MediaTypeCodecRegistry)localFunctionRegistry;
            return mediaTypeCodecRegistry.findCodec(mediaType);
        }
        return Optional.empty();
    }

    public Optional<MediaTypeCodec> findCodec(@Nullable MediaType mediaType, Class<?> type) {
        LocalFunctionRegistry localFunctionRegistry = this.localFunctionRegistry;
        if (localFunctionRegistry instanceof MediaTypeCodecRegistry) {
            MediaTypeCodecRegistry mediaTypeCodecRegistry = (MediaTypeCodecRegistry)localFunctionRegistry;
            return mediaTypeCodecRegistry.findCodec(mediaType, type);
        }
        return Optional.empty();
    }

    public Collection<MediaTypeCodec> getCodecs() {
        LocalFunctionRegistry localFunctionRegistry = this.localFunctionRegistry;
        if (localFunctionRegistry instanceof MediaTypeCodecRegistry) {
            MediaTypeCodecRegistry mediaTypeCodecRegistry = (MediaTypeCodecRegistry)localFunctionRegistry;
            return mediaTypeCodecRegistry.getCodecs();
        }
        return Collections.emptyList();
    }
}

