/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function.client.http;

import io.micronaut.core.annotation.AnnotationMetadataResolver;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.function.client.FunctionDefinition;
import io.micronaut.function.client.FunctionInvoker;
import io.micronaut.function.client.FunctionInvokerChooser;
import io.micronaut.function.client.exceptions.FunctionExecutionException;
import io.micronaut.function.client.exceptions.FunctionNotFoundException;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.client.DefaultHttpClient;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.http.client.LoadBalancer;
import io.micronaut.http.client.filter.HttpClientFilterResolver;
import io.micronaut.http.client.ssl.NettyClientSslBuilder;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.http.filter.HttpClientFilter;
import io.reactivex.Flowable;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.ThreadFactory;
import javax.annotation.PreDestroy;
import javax.inject.Named;
import javax.inject.Singleton;

@Singleton
public class HttpFunctionExecutor<I, O>
implements FunctionInvoker<I, O>,
Closeable,
FunctionInvokerChooser {
    private final DefaultHttpClient httpClient;

    public HttpFunctionExecutor(HttpClientConfiguration configuration, @Named(value="netty") ThreadFactory threadFactory, NettyClientSslBuilder nettyClientSslBuilder, MediaTypeCodecRegistry codecRegistry, AnnotationMetadataResolver annotationMetadataResolver, HttpClientFilter ... filters) {
        this.httpClient = new DefaultHttpClient(LoadBalancer.empty(), configuration, null, new HttpClientFilterResolver(null, null, annotationMetadataResolver, Arrays.asList(filters)), threadFactory, nettyClientSslBuilder, codecRegistry);
    }

    @Override
    public O invoke(FunctionDefinition definition, I input, Argument<O> outputType) {
        Class outputJavaType;
        Optional<URI> opt = definition.getURI();
        if (!opt.isPresent()) {
            throw new FunctionNotFoundException(definition.getName());
        }
        URI uri = opt.get();
        MutableHttpRequest request = input == null ? HttpRequest.GET((String)uri.toString()) : HttpRequest.POST((String)uri.toString(), input);
        if (input != null && ClassUtils.isJavaLangType(input.getClass())) {
            request.contentType(MediaType.TEXT_PLAIN_TYPE);
        }
        if (ClassUtils.isJavaLangType((Class)(outputJavaType = outputType.getType()))) {
            request.accept(new MediaType[]{MediaType.TEXT_PLAIN_TYPE});
        }
        if (Publishers.isConvertibleToPublisher((Class)outputJavaType)) {
            Flowable publisher = this.httpClient.retrieve((HttpRequest)request, outputType.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT));
            return (O)ConversionService.SHARED.convert((Object)publisher, outputType).orElseThrow(() -> new FunctionExecutionException("Unsupported Reactive type: " + outputJavaType));
        }
        return (O)this.httpClient.toBlocking().retrieve((HttpRequest)request, outputType);
    }

    public <I1, O2> Optional<FunctionInvoker<I1, O2>> choose(FunctionDefinition definition) {
        if (definition.getURI().isPresent()) {
            return Optional.of(this);
        }
        return Optional.empty();
    }

    @Override
    @PreDestroy
    public void close() throws IOException {
        this.httpClient.close();
    }
}

