/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function.client.aws;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSCredentialsProviderChain;
import com.amazonaws.auth.EC2ContainerCredentialsProviderWrapper;
import com.amazonaws.auth.EnvironmentVariableCredentialsProvider;
import com.amazonaws.auth.SystemPropertiesCredentialsProvider;
import com.amazonaws.auth.profile.ProfileCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.lambda.AWSLambdaAsyncClient;
import com.amazonaws.services.lambda.AWSLambdaAsyncClientBuilder;
import io.micronaut.configuration.aws.AWSClientConfiguration;
import io.micronaut.configuration.aws.EnvironmentAWSCredentialsProvider;
import io.micronaut.context.annotation.ConfigurationBuilder;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.env.Environment;
import io.micronaut.core.util.ArrayUtils;
import javax.annotation.Nullable;
import javax.inject.Inject;

@ConfigurationProperties(value="aws.lambda")
@Requires(classes={AWSLambdaAsyncClientBuilder.class})
public class AWSLambdaConfiguration {
    public static final String PREFIX = "aws.lambda";
    @ConfigurationBuilder(prefixes={"with"})
    AWSLambdaAsyncClientBuilder builder = AWSLambdaAsyncClient.asyncBuilder();
    private final AWSClientConfiguration clientConfiguration;

    public AWSLambdaConfiguration(AWSClientConfiguration clientConfiguration, Environment environment) {
        this.clientConfiguration = clientConfiguration;
        this.builder.setCredentials((AWSCredentialsProvider)new AWSCredentialsProviderChain(new AWSCredentialsProvider[]{new EnvironmentAWSCredentialsProvider(environment), new EnvironmentVariableCredentialsProvider(), new SystemPropertiesCredentialsProvider(), new ProfileCredentialsProvider(), new EC2ContainerCredentialsProviderWrapper()}));
    }

    public AWSLambdaAsyncClientBuilder getBuilder() {
        this.builder.setClientConfiguration(this.clientConfiguration.getClientConfiguration());
        return this.builder;
    }

    @Inject
    public void setMetricsCollector(@Nullable RequestMetricCollector metricsCollector) {
        if (metricsCollector != null) {
            this.builder.setMetricsCollector(metricsCollector);
        }
    }

    @Inject
    public void setEndpointConfiguration(@Nullable AwsClientBuilder.EndpointConfiguration endpointConfiguration) {
        if (endpointConfiguration != null) {
            this.builder.setEndpointConfiguration(endpointConfiguration);
        }
    }

    @Inject
    public void setRequestHandlers(RequestHandler2 ... handlers) {
        if (ArrayUtils.isNotEmpty((Object[])handlers)) {
            this.builder.setRequestHandlers(handlers);
        }
    }
}

