/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.value;

import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.naming.conventions.StringConvention;
import io.micronaut.core.type.Argument;
import io.micronaut.core.value.PropertyCatalog;
import io.micronaut.core.value.PropertyNotFoundException;
import io.micronaut.core.value.ValueResolver;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public interface PropertyResolver
extends ValueResolver<String> {
    public boolean containsProperty(@NonNull String var1);

    public boolean containsProperties(@NonNull String var1);

    public <T> @NonNull Optional<T> getProperty(@NonNull String var1, @NonNull ArgumentConversionContext<T> var2);

    default public @NonNull Collection<String> getPropertyEntries(@NonNull String name) {
        return Collections.emptySet();
    }

    default public @NonNull Collection<String> getPropertyEntries(@NonNull String name, @NonNull PropertyCatalog propertyCatalog) {
        return Collections.emptySet();
    }

    default public <T> @NonNull Optional<T> getProperty(@NonNull String name, @NonNull Argument<T> argument) {
        return this.getProperty(name, ConversionContext.of(argument));
    }

    default public @NonNull Map<String, Object> getProperties(@NonNull String name) {
        return this.getProperties(name, null);
    }

    default public @NonNull Map<String, Object> getProperties(@Nullable String name, @Nullable StringConvention keyFormat) {
        return Collections.emptyMap();
    }

    default public <T> @NonNull Optional<T> getProperty(@NonNull String name, @NonNull Class<T> requiredType, @NonNull ConversionContext context) {
        return this.getProperty(name, context.with(Argument.of(requiredType)));
    }

    @Override
    default public <T> @NonNull Optional<T> get(@NonNull String name, @NonNull ArgumentConversionContext<T> conversionContext) {
        return this.getProperty(name, conversionContext);
    }

    default public <T> @NonNull Optional<T> getProperty(@NonNull String name, @NonNull Class<T> requiredType) {
        return this.getProperty(name, requiredType, (T)ConversionContext.DEFAULT);
    }

    default public <T> @Nullable T getProperty(@NonNull String name, @NonNull Class<T> requiredType, @Nullable T defaultValue) {
        return this.getProperty(name, requiredType).orElse(defaultValue);
    }

    default public <T> @NonNull T getRequiredProperty(@NonNull String name, @NonNull Class<T> requiredType) throws PropertyNotFoundException {
        return this.getProperty(name, requiredType).orElseThrow(() -> new PropertyNotFoundException(name, requiredType));
    }

    public static String nameOf(String ... path) {
        return String.join((CharSequence)".", path);
    }

    public @NonNull Collection<List<String>> getPropertyPathMatches(@NonNull String var1);
}

