/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.util;

import io.micronaut.core.annotation.Internal;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

@Internal
public final class ObjectUtils {
    private ObjectUtils() {
    }

    public static int hash(@Nullable Object o1, @Nullable Object o2) {
        int result = 1;
        result = 31 * result + (o1 == null ? 0 : o1.hashCode());
        result = 31 * result + (o2 == null ? 0 : o2.hashCode());
        return result;
    }

    public static int hash(@Nullable Object o1, @Nullable Object o2, @Nullable Object o3) {
        int result = 1;
        result = 31 * result + (o1 == null ? 0 : o1.hashCode());
        result = 31 * result + (o2 == null ? 0 : o2.hashCode());
        result = 31 * result + (o3 == null ? 0 : o3.hashCode());
        return result;
    }

    public static boolean coerceToBoolean(@Nullable Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Boolean) {
            Boolean b = (Boolean)object;
            return b;
        }
        if (object instanceof CharSequence) {
            CharSequence charSequence = (CharSequence)object;
            return charSequence.length() > 0;
        }
        if (object instanceof Number) {
            Number n = (Number)object;
            return n.doubleValue() != 0.0;
        }
        if (object instanceof Collection) {
            Collection col = (Collection)object;
            return !col.isEmpty();
        }
        if (object instanceof Map) {
            Map col = (Map)object;
            return !col.isEmpty();
        }
        if (object instanceof Object[]) {
            Object[] array = (Object[])object;
            return array.length > 0;
        }
        if (object instanceof Optional) {
            Optional opt = (Optional)object;
            return opt.isPresent();
        }
        return true;
    }
}

