/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.propagation;

import io.micronaut.core.propagation.PropagatedContextElement;
import io.micronaut.core.propagation.PropagatedContextImpl;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jspecify.annotations.NonNull;

public interface PropagatedContext {
    public static @NonNull PropagatedContext empty() {
        return PropagatedContextImpl.EMPTY;
    }

    public static @NonNull PropagatedContext getOrEmpty() {
        return PropagatedContextImpl.getOrEmpty();
    }

    public static @NonNull PropagatedContext get() {
        return PropagatedContextImpl.get();
    }

    public static @NonNull Optional<PropagatedContext> find() {
        return PropagatedContextImpl.find();
    }

    public static @NonNull Runnable wrapCurrent(@NonNull Runnable runnable) {
        return PropagatedContext.find().map(ctx -> ctx.wrap(runnable)).orElse(runnable);
    }

    public static <V> @NonNull Callable<V> wrapCurrent(@NonNull Callable<V> callable) {
        return PropagatedContext.find().map(ctx -> ctx.wrap(callable)).orElse(callable);
    }

    public static <V> @NonNull Supplier<V> wrapCurrent(@NonNull Supplier<V> supplier) {
        return PropagatedContext.find().map(ctx -> ctx.wrap(supplier)).orElse(supplier);
    }

    public static boolean exists() {
        return PropagatedContextImpl.exists();
    }

    public @NonNull PropagatedContext plus(@NonNull PropagatedContextElement var1);

    public @NonNull PropagatedContext minus(@NonNull PropagatedContextElement var1);

    public @NonNull PropagatedContext replace(@NonNull PropagatedContextElement var1, @NonNull PropagatedContextElement var2);

    public <T extends PropagatedContextElement> Optional<T> find(@NonNull Class<T> var1);

    public <T extends PropagatedContextElement> Stream<T> findAll(@NonNull Class<T> var1);

    public <T extends PropagatedContextElement> T get(@NonNull Class<T> var1);

    public List<PropagatedContextElement> getAllElements();

    public @NonNull Scope propagate();

    default public @NonNull Runnable wrap(@NonNull Runnable runnable) {
        PropagatedContext propagatedContext = this;
        return () -> {
            try (Scope ignore = propagatedContext.propagate();){
                runnable.run();
            }
        };
    }

    default public <V> @NonNull Callable<V> wrap(@NonNull Callable<V> callable) {
        PropagatedContext propagatedContext = this;
        return () -> {
            try (Scope ignore = propagatedContext.propagate();){
                Object v = callable.call();
                return v;
            }
        };
    }

    default public <V> @NonNull Supplier<V> wrap(@NonNull Supplier<V> supplier) {
        PropagatedContext propagatedContext = this;
        return () -> {
            try (Scope ignore = propagatedContext.propagate();){
                Object t = supplier.get();
                return t;
            }
        };
    }

    default public <V> @NonNull V propagate(@NonNull Supplier<V> supplier) {
        try (Scope ignore = this.propagate();){
            V v = supplier.get();
            return v;
        }
    }

    public static interface Scope
    extends AutoCloseable {
        @Override
        public void close();
    }
}

