/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.naming.conventions;

import io.micronaut.core.naming.NameUtils;
import java.util.Locale;

public enum StringConvention {
    CAMEL_CASE_CAPITALIZED,
    CAMEL_CASE,
    HYPHENATED,
    RAW,
    UNDER_SCORE_SEPARATED,
    UNDER_SCORE_SEPARATED_LOWER_CASE;


    public String format(String str) {
        return StringConvention.format(this, str);
    }

    public static String format(StringConvention convention, String str) {
        switch (convention.ordinal()) {
            case 1: {
                return NameUtils.camelCase(str);
            }
            case 2: {
                return NameUtils.hyphenate(str);
            }
            case 5: {
                return NameUtils.underscoreSeparate(str.toLowerCase(Locale.ENGLISH));
            }
            case 4: {
                return NameUtils.environmentName(str);
            }
            case 0: {
                return NameUtils.camelCase(str, false);
            }
        }
        return str;
    }
}

