/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.naming;

import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.StringUtils;
import java.util.Locale;
import java.util.regex.Pattern;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class NameUtils {
    private static final int IS_LENGTH = 2;
    private static final String PREFIX_GET = "get";
    private static final String PREFIX_SET = "set";
    private static final String PREFIX_IS = "is";
    private static final Pattern ENVIRONMENT_VAR_SEQUENCE = Pattern.compile("^[\\p{Lu}_{0-9}]+");
    private static final Pattern KEBAB_CASE_SEQUENCE = Pattern.compile("^(([a-z0-9])+([-.:])?)*([a-z0-9])+$");

    public static boolean isHyphenatedLowerCase(@Nullable String name) {
        if (name == null || name.isEmpty() || !Character.isLetter(name.charAt(0))) {
            return false;
        }
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isLowerCase(c) || c >= '0' && c <= '9' || c == '-') continue;
            return false;
        }
        return true;
    }

    public static @NonNull String decapitalizeWithoutSuffix(@NonNull String name, String ... suffixes) {
        String decapitalized = NameUtils.decapitalize(name);
        return NameUtils.trimSuffix(decapitalized, suffixes);
    }

    public static @NonNull String trimSuffix(@NonNull String string, String ... suffixes) {
        if (suffixes != null) {
            for (String suffix : suffixes) {
                if (!string.endsWith(suffix)) continue;
                return string.substring(0, string.length() - suffix.length());
            }
        }
        return string;
    }

    public static @NonNull String capitalize(@NonNull String name) {
        String rest = name.substring(1);
        if (Character.isLowerCase(name.charAt(0)) && !rest.isEmpty() && Character.isUpperCase(rest.charAt(0))) {
            return name;
        }
        return name.substring(0, 1).toUpperCase(Locale.ENGLISH) + rest;
    }

    public static @NonNull String hyphenate(@NonNull String name) {
        return NameUtils.hyphenate(name, true);
    }

    public static @NonNull String hyphenate(@NonNull String name, boolean lowerCase) {
        String kebabReplaced = name.replace('_', '-').replace(' ', '-');
        if (NameUtils.isHyphenatedLowerCase(name)) {
            return kebabReplaced;
        }
        return NameUtils.separateCamelCase(kebabReplaced, lowerCase, '-');
    }

    public static @NonNull String dehyphenate(@NonNull String name) {
        StringBuilder sb = new StringBuilder(name.length());
        for (String token : StringUtils.splitOmitEmptyStrings(name, '-')) {
            if (!token.isEmpty() && Character.isLetter(token.charAt(0))) {
                sb.append(Character.toUpperCase(token.charAt(0)));
                sb.append(token.substring(1));
                continue;
            }
            sb.append(token);
        }
        return sb.toString();
    }

    public static @NonNull String getPackageName(@NonNull String className) {
        int len = className.length();
        for (int i = len - 1; i != 0; --i) {
            if (className.charAt(i) != '.') continue;
            return className.substring(0, i);
        }
        return "";
    }

    public static @NonNull String underscoreSeparate(@NonNull String camelCase) {
        return NameUtils.underscoreSeparate(camelCase, false);
    }

    public static @NonNull String underscoreSeparate(@NonNull String camelCase, boolean lowercase) {
        return NameUtils.separateCamelCase(camelCase.replace('-', '_'), lowercase, '_');
    }

    public static @NonNull String environmentName(@NonNull String camelCase) {
        return NameUtils.separateCamelCase(camelCase.replace('-', '_').replace('.', '_'), false, '_').toUpperCase(Locale.ENGLISH);
    }

    public static @NonNull String getSimpleName(@NonNull String className) {
        int len = className.length();
        for (int i = len - 1; i >= 0; --i) {
            if (className.charAt(i) != '.') continue;
            return className.substring(i + 1);
        }
        return className;
    }

    public static @NonNull String getShortenedName(@NonNull String typeName) {
        int nameStart = typeName.lastIndexOf(36);
        if (nameStart < 0) {
            nameStart = typeName.lastIndexOf(46);
        }
        if (nameStart < 0) {
            nameStart = 0;
        }
        StringBuilder shortened = new StringBuilder();
        boolean segmentStart = true;
        for (int i = 0; i < nameStart; ++i) {
            char c = typeName.charAt(i);
            if (segmentStart) {
                shortened.append(c);
                segmentStart = false;
                continue;
            }
            if (c != '.' && c != '$') continue;
            shortened.append(c);
            segmentStart = true;
        }
        return shortened.append(typeName.substring(nameStart)).toString();
    }

    public static boolean isSetterName(@NonNull String methodName) {
        return NameUtils.isWriterName(methodName, PREFIX_SET);
    }

    public static boolean isWriterName(@NonNull String methodName, @NonNull String writePrefix) {
        return NameUtils.isWriterName(methodName, new String[]{writePrefix});
    }

    public static boolean isWriterName(@NonNull String methodName, @NonNull String[] writePrefixes) {
        boolean isValid = false;
        for (String writePrefix : writePrefixes) {
            int prefixLength;
            if (writePrefix.isEmpty()) {
                return true;
            }
            int len = methodName.length();
            if (len > (prefixLength = writePrefix.length()) && methodName.startsWith(writePrefix)) {
                char nextChar = methodName.charAt(prefixLength);
                isValid = NameUtils.isValidCharacterAfterReaderWriterPrefix(nextChar);
            }
            if (isValid) break;
        }
        return isValid;
    }

    public static @NonNull String getPropertyNameForSetter(@NonNull String setterName) {
        return NameUtils.getPropertyNameForSetter(setterName, PREFIX_SET);
    }

    public static @NonNull String getPropertyNameForSetter(@NonNull String setterName, @NonNull String writePrefix) {
        return NameUtils.getPropertyNameForSetter(setterName, new String[]{writePrefix});
    }

    public static @NonNull String getPropertyNameForSetter(@NonNull String setterName, @NonNull String[] writePrefixes) {
        for (String writePrefix : writePrefixes) {
            if (!NameUtils.isWriterName(setterName, writePrefix)) continue;
            return NameUtils.decapitalize(setterName.substring(writePrefix.length()));
        }
        return setterName;
    }

    public static @NonNull String setterNameFor(@NonNull String propertyName) {
        return NameUtils.setterNameFor(propertyName, PREFIX_SET);
    }

    public static @NonNull String setterNameFor(@NonNull String propertyName, @NonNull String[] prefixes) {
        if (prefixes.length == 0) {
            return NameUtils.setterNameFor(propertyName, "");
        }
        return NameUtils.setterNameFor(propertyName, prefixes[0]);
    }

    public static @NonNull String setterNameFor(@NonNull String propertyName, @NonNull String prefix) {
        ArgumentUtils.requireNonNull("propertyName", propertyName);
        ArgumentUtils.requireNonNull("prefix", prefix);
        return NameUtils.nameFor(prefix, propertyName);
    }

    public static boolean isGetterName(@NonNull String methodName) {
        return NameUtils.isReaderName(methodName, PREFIX_GET);
    }

    public static boolean isReaderName(@NonNull String methodName, @NonNull String readPrefix) {
        return NameUtils.isReaderName(methodName, new String[]{readPrefix});
    }

    public static boolean isReaderName(@NonNull String methodName, @NonNull String[] readPrefixes) {
        boolean isValid = false;
        for (String readPrefix : readPrefixes) {
            int prefixLength = 0;
            if (readPrefix.isEmpty()) {
                return true;
            }
            if (methodName.startsWith(readPrefix)) {
                prefixLength = readPrefix.length();
            } else if (methodName.startsWith(PREFIX_IS) && readPrefix.equals(PREFIX_GET)) {
                prefixLength = 2;
            }
            int len = methodName.length();
            if (len > prefixLength) {
                char firstVarNameChar = methodName.charAt(prefixLength);
                isValid = NameUtils.isValidCharacterAfterReaderWriterPrefix(firstVarNameChar);
            }
            if (isValid) break;
        }
        return isValid;
    }

    private static boolean isValidCharacterAfterReaderWriterPrefix(char c) {
        return c == '_' || c == '$' || Character.isUpperCase(c);
    }

    public static @NonNull String getPropertyNameForGetter(@NonNull String getterName) {
        return NameUtils.getPropertyNameForGetter(getterName, PREFIX_GET);
    }

    public static @NonNull String getPropertyNameForGetter(@NonNull String getterName, @NonNull String readPrefix) {
        return NameUtils.getPropertyNameForGetter(getterName, new String[]{readPrefix});
    }

    public static @NonNull String getPropertyNameForGetter(@NonNull String getterName, @NonNull String[] readPrefixes) {
        for (String readPrefix : readPrefixes) {
            if (!NameUtils.isReaderName(getterName, readPrefix)) continue;
            int prefixLength = 0;
            if (getterName.startsWith(readPrefix)) {
                prefixLength = readPrefix.length();
            }
            if (getterName.startsWith(PREFIX_IS) && readPrefix.equals(PREFIX_GET)) {
                prefixLength = 2;
            }
            return NameUtils.decapitalize(getterName.substring(prefixLength));
        }
        return getterName;
    }

    public static @NonNull String getterNameFor(@NonNull String propertyName) {
        return NameUtils.getterNameFor(propertyName, PREFIX_GET);
    }

    public static @NonNull String getterNameFor(@NonNull String propertyName, @NonNull String[] prefixes) {
        if (prefixes.length == 0) {
            return NameUtils.getterNameFor(propertyName, "");
        }
        return NameUtils.getterNameFor(propertyName, prefixes[0]);
    }

    public static @NonNull String getterNameFor(@NonNull String propertyName, @NonNull String prefix) {
        ArgumentUtils.requireNonNull("propertyName", propertyName);
        ArgumentUtils.requireNonNull("prefix", prefix);
        return NameUtils.nameFor(prefix, propertyName);
    }

    public static @NonNull String getterNameFor(@NonNull String propertyName, @NonNull Class<?> type) {
        ArgumentUtils.requireNonNull("propertyName", propertyName);
        boolean isBoolean = type == Boolean.TYPE;
        return NameUtils.getterNameFor(propertyName, isBoolean);
    }

    public static String getterNameFor(@NonNull String propertyName, boolean isBoolean) {
        return NameUtils.nameFor(isBoolean ? PREFIX_IS : PREFIX_GET, propertyName);
    }

    private static @NonNull String nameFor(@Nullable String prefix, @NonNull String propertyName) {
        if (StringUtils.isEmpty(prefix)) {
            return propertyName;
        }
        int len = propertyName.length();
        switch (len) {
            case 0: {
                return propertyName;
            }
            case 1: {
                return prefix + propertyName.toUpperCase(Locale.ENGLISH);
            }
        }
        return prefix + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
    }

    public static @Nullable String decapitalize(@Nullable String name) {
        if (name == null) {
            return null;
        }
        int length = name.length();
        if (length == 0) {
            return name;
        }
        boolean firstUpper = Character.isUpperCase(name.charAt(0));
        if (firstUpper) {
            if (length == 1) {
                return Character.toString(Character.toLowerCase(name.charAt(0)));
            }
            for (int i = 1; i < Math.min(length, 3); ++i) {
                if (Character.isUpperCase(name.charAt(i))) continue;
                char[] chars = name.toCharArray();
                chars[0] = Character.toLowerCase(chars[0]);
                return new String(chars);
            }
        }
        return name;
    }

    static @NonNull String separateCamelCase(@NonNull String name, boolean lowerCase, char separatorChar) {
        StringBuilder newName = new StringBuilder(name.length() + 4);
        if (!lowerCase) {
            boolean first = true;
            char last = '0';
            for (int i = 0; i < name.length(); ++i) {
                char c = name.charAt(i);
                if (first) {
                    if (c != separatorChar) {
                        newName.append(c);
                    }
                    first = false;
                } else if (Character.isUpperCase(c) && !Character.isUpperCase(last)) {
                    if (c != separatorChar) {
                        newName.append(separatorChar);
                    }
                    newName.append(c);
                } else {
                    if (c == '.') {
                        first = true;
                    }
                    if (c != separatorChar) {
                        if (last == separatorChar) {
                            newName.append(separatorChar);
                        }
                        newName.append(c);
                    }
                }
                last = c;
            }
        } else {
            boolean first = true;
            char last = '0';
            char secondLast = separatorChar;
            for (int i = 0; i < name.length(); ++i) {
                char c = name.charAt(i);
                if (Character.isLowerCase(c) || !Character.isLetter(c)) {
                    first = false;
                    if (c != separatorChar) {
                        if (last == separatorChar) {
                            newName.append(separatorChar);
                        }
                        newName.append(c);
                    }
                } else {
                    char lowerCaseChar = Character.toLowerCase(c);
                    if (first) {
                        first = false;
                        newName.append(lowerCaseChar);
                    } else if (Character.isUpperCase(last) || last == '.') {
                        newName.append(lowerCaseChar);
                    } else if (Character.isDigit(last) && (Character.isUpperCase(secondLast) || secondLast == separatorChar)) {
                        newName.append(lowerCaseChar);
                    } else {
                        newName.append(separatorChar).append(lowerCaseChar);
                    }
                }
                if (i > 1) {
                    secondLast = last;
                }
                last = c;
            }
        }
        return newName.toString();
    }

    public static @NonNull String extension(@NonNull String filename) {
        int index;
        int lastWindowsPos;
        int extensionPos = filename.lastIndexOf(46);
        int lastUnixPos = filename.lastIndexOf(47);
        int lastSeparator = Math.max(lastUnixPos, lastWindowsPos = filename.lastIndexOf(92));
        int n = index = lastSeparator > extensionPos ? -1 : extensionPos;
        if (index == -1) {
            return "";
        }
        return filename.substring(index + 1);
    }

    public static @NonNull String camelCase(@NonNull String str) {
        return NameUtils.camelCase(str, true);
    }

    public static @NonNull String camelCase(@NonNull String str, boolean lowerCaseFirstLetter) {
        StringBuilder sb = new StringBuilder(str.length());
        for (String s : str.split("[\\s_-]")) {
            String capitalize = NameUtils.capitalize(s);
            sb.append(capitalize);
        }
        String result = sb.toString();
        if (lowerCaseFirstLetter) {
            return NameUtils.decapitalize(result);
        }
        return result;
    }

    public static @NonNull String filename(@NonNull String path) {
        int index;
        int lastWindowsPos;
        int extensionPos = path.lastIndexOf(46);
        int lastUnixPos = path.lastIndexOf(47);
        int lastSeparator = Math.max(lastUnixPos, lastWindowsPos = path.lastIndexOf(92));
        int n = index = lastSeparator > extensionPos ? path.length() : extensionPos;
        if (index == -1) {
            return "";
        }
        return path.substring(lastSeparator + 1, index);
    }

    public static boolean isValidHyphenatedPropertyName(@NonNull String str) {
        return KEBAB_CASE_SEQUENCE.matcher(str).matches();
    }

    public static boolean isEnvironmentName(@NonNull String str) {
        return ENVIRONMENT_VAR_SEQUENCE.matcher(str).matches();
    }
}

