/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.io.service;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.io.service.MicronautMetaServiceLoaderUtils;
import io.micronaut.core.io.service.SoftServiceLoader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RecursiveAction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.graalvm.nativeimage.ImageSingletons;
import org.jspecify.annotations.Nullable;

@Internal
final class ServiceScanner<S> {
    private final ClassLoader classLoader;
    private final String serviceName;
    private final Predicate<String> lineCondition;
    private final Function<String, S> transformer;

    public ServiceScanner(ClassLoader classLoader, String serviceName, Predicate<String> lineCondition, Function<String, S> transformer) {
        this.classLoader = classLoader;
        this.serviceName = serviceName;
        this.lineCondition = lineCondition;
        this.transformer = transformer;
    }

    static @Nullable StaticServiceDefinitions findStaticServiceDefinitions() {
        if (ServiceScanner.hasImageSingletons()) {
            return ImageSingletons.contains(StaticServiceDefinitions.class) ? (StaticServiceDefinitions)ImageSingletons.lookup(StaticServiceDefinitions.class) : null;
        }
        return null;
    }

    private static boolean hasImageSingletons() {
        try {
            return ImageSingletons.class != null;
        }
        catch (Throwable e) {
            return false;
        }
    }

    SoftServiceLoader.ServiceCollector<S> createCollector() {
        return new SoftServiceLoader.ServiceCollector<S>(){

            @Override
            public void collect(Collection<S> values) {
                this.collect(values::add, true);
            }

            @Override
            public void collect(Collection<S> values, boolean allowFork) {
                this.collect(values::add, allowFork);
            }

            @Override
            public void collect(Consumer<? super S> consumer) {
                this.collect(consumer, true);
            }

            @Override
            private void collect(Consumer<? super S> consumer, boolean allowFork) {
                boolean fork = allowFork && ForkJoinPool.getCommonPoolParallelism() > 1;
                ServiceEntriesLoader task = new ServiceEntriesLoader(ServiceScanner.this.serviceName, ServiceScanner.this.classLoader, ServiceScanner.this.lineCondition, ServiceScanner.this.transformer, fork);
                if (fork) {
                    ForkJoinPool.commonPool().invoke(task);
                } else {
                    task.compute();
                }
                task.consume(consumer);
            }
        };
    }

    @Internal
    record StaticServiceDefinitions(Map<String, Set<String>> serviceTypeMap) {
        StaticServiceDefinitions {
            if (serviceTypeMap == null) {
                serviceTypeMap = new HashMap<String, Set<String>>();
            }
        }
    }

    private static abstract class RecursiveActionValuesCollector<S>
    extends RecursiveAction {
        private RecursiveActionValuesCollector() {
        }

        public abstract void consume(Consumer<? super S> var1);
    }

    private static final class ServiceInstanceLoader<S>
    extends RecursiveActionValuesCollector<S> {
        private final String className;
        private S result;
        private Throwable throwable;
        private final Function<String, S> transformer;

        public ServiceInstanceLoader(String className, Function<String, S> transformer) {
            this.className = className;
            this.transformer = transformer;
        }

        @Override
        protected void compute() {
            try {
                this.result = this.transformer.apply(this.className);
            }
            catch (Throwable e) {
                this.throwable = e;
            }
        }

        @Override
        public void consume(Consumer<? super S> consumer) {
            if (this.throwable != null) {
                throw new SoftServiceLoader.ServiceLoadingException("Failed to load a service: " + this.throwable.getMessage(), this.throwable);
            }
            if (this.result != null) {
                consumer.accept(this.result);
            }
        }
    }

    private static final class UrlServicesLoader<S>
    extends RecursiveActionValuesCollector<S> {
        private final URL url;
        private final List<ServiceInstanceLoader<S>> tasks = new ArrayList<ServiceInstanceLoader<S>>();
        private final Predicate<String> lineCondition;
        private final Function<String, S> transformer;
        private final boolean fork;

        public UrlServicesLoader(URL url, Predicate<String> lineCondition, Function<String, S> transformer, boolean fork) {
            this.url = url;
            this.lineCondition = lineCondition;
            this.transformer = transformer;
            this.fork = fork;
        }

        @Override
        protected void compute() {
            for (String typeName : this.computeStandardServiceTypeNames(this.url)) {
                ServiceInstanceLoader<S> task = new ServiceInstanceLoader<S>(typeName, this.transformer);
                this.tasks.add(task);
                if (this.fork) {
                    task.fork();
                    continue;
                }
                task.compute();
            }
        }

        @Override
        public void consume(Consumer<? super S> consumer) {
            for (ServiceInstanceLoader<? super S> serviceInstanceLoader : this.tasks) {
                if (this.fork) {
                    serviceInstanceLoader.join();
                }
                serviceInstanceLoader.consume(consumer);
            }
        }

        private Set<String> computeStandardServiceTypeNames(URL url) {
            HashSet<String> typeNames = new HashSet<String>();
            try {
                URLConnection uc = url.openConnection();
                uc.setUseCaches(false);
                try (InputStream is = uc.getInputStream();
                     BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        if (line.isEmpty() || line.charAt(0) == '#' || !this.lineCondition.test(line)) continue;
                        int i = line.indexOf(35);
                        if (i > -1) {
                            line = line.substring(0, i);
                        }
                        typeNames.add(line);
                    }
                }
            }
            catch (IOException | UncheckedIOException exception) {
                // empty catch block
            }
            return typeNames;
        }
    }

    private static final class ServiceEntriesLoader<S>
    extends RecursiveActionValuesCollector<S> {
        private final List<RecursiveActionValuesCollector<S>> tasks = new ArrayList<RecursiveActionValuesCollector<S>>();
        private final String serviceName;
        private final ClassLoader classLoader;
        private final Predicate<String> lineCondition;
        private final Function<String, S> transformer;
        private final boolean fork;
        private final Set<String> serviceEntries;

        private ServiceEntriesLoader(String serviceName, ClassLoader classLoader, Predicate<String> lineCondition, Function<String, S> transformer, boolean fork) {
            this.serviceName = serviceName;
            this.classLoader = classLoader;
            this.lineCondition = lineCondition;
            this.transformer = transformer;
            StaticServiceDefinitions ssd = ServiceScanner.findStaticServiceDefinitions();
            if (ssd != null) {
                Map<String, Set<String>> stringSetMap = ssd.serviceTypeMap();
                this.serviceEntries = stringSetMap.get(serviceName);
                this.fork = this.serviceEntries == null ? fork : false;
            } else {
                this.serviceEntries = null;
                this.fork = fork;
            }
        }

        @Override
        protected void compute() {
            try {
                if (this.serviceEntries != null) {
                    for (String serviceEntry : this.serviceEntries) {
                        ServiceInstanceLoader<S> task = new ServiceInstanceLoader<S>(serviceEntry, this.transformer);
                        this.tasks.add(task);
                        if (this.fork) {
                            task.fork();
                            continue;
                        }
                        task.compute();
                    }
                    return;
                }
                Enumeration<URL> serviceConfigs = this.findStandardServiceConfigs();
                while (serviceConfigs.hasMoreElements()) {
                    URL url = serviceConfigs.nextElement();
                    UrlServicesLoader<S> task = new UrlServicesLoader<S>(url, this.lineCondition, this.transformer, this.fork);
                    this.tasks.add(task);
                    if (this.fork) {
                        task.fork();
                        continue;
                    }
                    task.compute();
                }
                Set<String> serviceEntries = MicronautMetaServiceLoaderUtils.findMicronautMetaServiceEntries(this.classLoader, this.serviceName);
                for (String serviceEntry : serviceEntries) {
                    ServiceInstanceLoader<S> task = new ServiceInstanceLoader<S>(serviceEntry, this.transformer);
                    this.tasks.add(task);
                    if (this.fork) {
                        task.fork();
                        continue;
                    }
                    task.compute();
                }
            }
            catch (IOException e) {
                throw new ServiceConfigurationError("Failed to load resources for service: " + this.serviceName, e);
            }
        }

        private Enumeration<URL> findStandardServiceConfigs() throws IOException {
            return this.classLoader.getResources("META-INF/services/" + this.serviceName);
        }

        @Override
        public void consume(Consumer<? super S> consumer) {
            for (RecursiveActionValuesCollector<? super S> recursiveActionValuesCollector : this.tasks) {
                if (this.fork) {
                    recursiveActionValuesCollector.join();
                }
                recursiveActionValuesCollector.consume(consumer);
            }
        }
    }
}

