/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.io.service;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.io.IOUtils;
import io.micronaut.core.io.service.ServiceScanner;
import io.micronaut.core.io.service.SoftServiceLoader;
import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.URI;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RecursiveAction;
import java.util.function.Predicate;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Internal
public final class MicronautMetaServiceLoaderUtils {
    private static final String MICRONAUT_SERVICES_PATH = "META-INF/micronaut/";
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.publicLookup();
    private static final MethodType VOID_TYPE = MethodType.methodType(Void.TYPE);
    private static volatile CacheEntry cacheEntry;

    public static <S> @NonNull List<S> findMetaMicronautServiceEntries(@NonNull ClassLoader classLoader, @NonNull Class<S> serviceClass, @Nullable Predicate<S> predicate) {
        SoftServiceLoader.StaticServiceLoader<?> staticServiceLoader = SoftServiceLoader.STATIC_SERVICES.get(serviceClass.getName());
        if (staticServiceLoader != null) {
            return staticServiceLoader.load(predicate);
        }
        return new MicronautServiceCollector<S>(classLoader, serviceClass.getName(), predicate).collect(true);
    }

    public static @NonNull Set<String> findMicronautMetaServiceEntries(@NonNull ClassLoader classLoader, @NonNull String serviceName) throws IOException {
        CacheEntry ce = cacheEntry;
        if (ce == null || ce.classLoader != classLoader) {
            cacheEntry = ce = new CacheEntry(classLoader, MicronautMetaServiceLoaderUtils.findAllMicronautMetaServices(classLoader));
        }
        return ce.services.getOrDefault(serviceName, Set.of());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static @NonNull Map<String, Set<String>> findAllMicronautMetaServices(@NonNull ClassLoader classLoader) throws IOException {
        ServiceScanner.StaticServiceDefinitions ssd = ServiceScanner.findStaticServiceDefinitions();
        if (ssd != null) {
            return ssd.serviceTypeMap();
        }
        List<URI> resourceDefs = IOUtils.getResources(classLoader, MICRONAUT_SERVICES_PATH);
        if (resourceDefs.isEmpty()) {
            return Map.of();
        }
        final LinkedHashMap<String, Set<String>> services = new LinkedHashMap<String, Set<String>>();
        FileVisitor<Path> visitor = new FileVisitor<Path>(){
            private Set<String> definitions;

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                if (dir.endsWith(MicronautMetaServiceLoaderUtils.MICRONAUT_SERVICES_PATH)) {
                    return FileVisitResult.CONTINUE;
                }
                String serviceName = dir.getFileName().toString();
                this.definitions = (Set)services.get(serviceName);
                if (this.definitions == null) {
                    this.definitions = new LinkedHashSet<String>();
                    services.put(serviceName, this.definitions);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path currentPath, BasicFileAttributes attrs) throws IOException {
                if (Files.isHidden(currentPath)) {
                    return FileVisitResult.CONTINUE;
                }
                Path fileName = currentPath.getFileName();
                if (fileName.startsWith(".")) {
                    return FileVisitResult.CONTINUE;
                }
                this.definitions.add(fileName.toString());
                return FileVisitResult.SKIP_SUBTREE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                return FileVisitResult.CONTINUE;
            }
        };
        ArrayList<Closeable> toClose = new ArrayList<Closeable>();
        try {
            for (URI uri : resourceDefs) {
                Path myPath = IOUtils.resolvePath(uri, MICRONAUT_SERVICES_PATH, toClose);
                if (myPath == null) continue;
                Files.walkFileTree(myPath, Collections.emptySet(), 2, (FileVisitor<? super Path>)visitor);
            }
        }
        catch (IOException iOException) {
            for (Closeable closeable : toClose) {
                try {
                    closeable.close();
                }
                catch (IOException iOException2) {}
            }
        }
        finally {
            for (Closeable closeable : toClose) {
                try {
                    closeable.close();
                }
                catch (IOException iOException) {}
            }
        }
        return services;
    }

    private static <S> S instantiate(String className, ClassLoader classLoader) {
        try {
            Class<?> loadedClass = Class.forName(className, false, classLoader);
            return (S)LOOKUP.findConstructor(loadedClass, VOID_TYPE).invoke();
        }
        catch (ClassNotFoundException | IllegalAccessError | IllegalAccessException | NoClassDefFoundError | NoSuchMethodException e) {
            return null;
        }
        catch (Throwable e) {
            return (S)MicronautMetaServiceLoaderUtils.sneakyThrow(e);
        }
    }

    private static <T extends Throwable, R> R sneakyThrow(Throwable t) throws T {
        throw t;
    }

    private static final class MicronautServiceCollector<S>
    extends RecursiveActionValuesCollector<S> {
        private final ClassLoader classLoader;
        private final String serviceName;
        private final Predicate<S> predicate;
        private final List<RecursiveActionValuesCollector<S>> tasks = new ArrayList<RecursiveActionValuesCollector<S>>();
        private int size;

        MicronautServiceCollector(ClassLoader classLoader, String serviceName, Predicate<S> predicate) {
            this.classLoader = classLoader;
            this.serviceName = serviceName;
            this.predicate = predicate;
        }

        @Override
        protected void compute() {
            try {
                Set<String> serviceEntries = MicronautMetaServiceLoaderUtils.findMicronautMetaServiceEntries(this.classLoader, this.serviceName);
                this.size = serviceEntries.size();
                for (String serviceEntry : serviceEntries) {
                    ServiceInstanceLoader<S> task = new ServiceInstanceLoader<S>(this.classLoader, serviceEntry, this.predicate);
                    this.tasks.add(task);
                    task.fork();
                }
            }
            catch (IOException e) {
                throw new ServiceConfigurationError("Failed to load resources for service: " + this.serviceName, e);
            }
        }

        public List<S> collect(boolean allowFork) {
            if (allowFork && ForkJoinPool.getCommonPoolParallelism() > 1) {
                ForkJoinPool.commonPool().invoke(this);
                ArrayList collection = null;
                for (RecursiveActionValuesCollector recursiveActionValuesCollector : this.tasks) {
                    recursiveActionValuesCollector.join();
                    if (collection == null) {
                        collection = new ArrayList(this.size);
                    }
                    recursiveActionValuesCollector.collect(collection);
                }
                if (collection == null) {
                    return List.of();
                }
                return collection;
            }
            try {
                Set<String> serviceEntries = MicronautMetaServiceLoaderUtils.findMicronautMetaServiceEntries(this.classLoader, this.serviceName);
                ArrayList collection = new ArrayList(serviceEntries.size());
                for (String serviceEntry : serviceEntries) {
                    Object val = MicronautMetaServiceLoaderUtils.instantiate(serviceEntry, this.classLoader);
                    if (val == null || this.predicate != null && !this.predicate.test(val)) continue;
                    collection.add(val);
                }
                return collection;
            }
            catch (IOException e) {
                throw new ServiceConfigurationError("Failed to load resources for service: " + this.serviceName, e);
            }
        }

        @Override
        public void collect(Collection<S> values) {
            throw new IllegalStateException("Only constructor method is supported!");
        }
    }

    private record CacheEntry(ClassLoader classLoader, Map<String, Set<String>> services) {
    }

    private static abstract class RecursiveActionValuesCollector<S>
    extends RecursiveAction {
        private RecursiveActionValuesCollector() {
        }

        public abstract void collect(Collection<S> var1);
    }

    private static final class ServiceInstanceLoader<S>
    extends RecursiveActionValuesCollector<S> {
        private final ClassLoader classLoader;
        private final String className;
        private final Predicate<S> predicate;
        private S result;
        private Throwable throwable;

        public ServiceInstanceLoader(ClassLoader classLoader, String className, Predicate<S> predicate) {
            this.classLoader = classLoader;
            this.className = className;
            this.predicate = predicate;
        }

        @Override
        protected void compute() {
            try {
                this.result = MicronautMetaServiceLoaderUtils.instantiate(this.className, this.classLoader);
                if (this.result != null && this.predicate != null && !this.predicate.test(this.result)) {
                    this.result = null;
                }
            }
            catch (Throwable e) {
                this.throwable = e;
            }
        }

        @Override
        public void collect(Collection<S> values) {
            if (this.throwable != null) {
                throw new SoftServiceLoader.ServiceLoadingException("Failed to load a service: " + this.throwable.getMessage(), this.throwable);
            }
            if (this.result != null) {
                values.add(this.result);
            }
        }
    }
}

