/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.io.service;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.io.service.ServiceDefinition;
import java.util.Optional;
import java.util.ServiceConfigurationError;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;

@Internal
final class DefaultServiceDefinition<S>
implements ServiceDefinition<S> {
    private final String name;
    private final @Nullable Class<S> loadedClass;

    DefaultServiceDefinition(String name, @Nullable Class<S> loadedClass) {
        this.name = name;
        this.loadedClass = loadedClass;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isPresent() {
        return this.loadedClass != null;
    }

    @Override
    public <X extends Throwable> S orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.loadedClass == null) {
            throw (Throwable)exceptionSupplier.get();
        }
        try {
            return this.loadedClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable e) {
            throw (Throwable)exceptionSupplier.get();
        }
    }

    @Override
    public S load() {
        return (S)Optional.ofNullable(this.loadedClass).map(aClass -> {
            try {
                return aClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable e) {
                throw new ServiceConfigurationError("Error loading service [" + aClass.getName() + "]: " + e.getMessage(), e);
            }
        }).orElseThrow(() -> new ServiceConfigurationError("Call to load() when class '" + this.name + "' is not present"));
    }
}

