/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.io.scan;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;
import org.jspecify.annotations.NonNull;

public interface AnnotationScanner {
    public @NonNull Stream<Class<?>> scan(@NonNull String var1, @NonNull String var2);

    default public @NonNull Stream<Class<?>> scan(@NonNull String annotation, Package ... packages) {
        Objects.requireNonNull(annotation, "Annotation type cannot be null");
        Objects.requireNonNull(packages, "Packages to scan cannot be null");
        return ((Stream)Arrays.stream(packages).parallel()).flatMap(pkg -> this.scan(annotation, pkg.getName()));
    }

    default public @NonNull Stream<Class<?>> scan(@NonNull Class<? extends Annotation> annotation, Package ... packages) {
        Objects.requireNonNull(annotation, "Annotation type cannot be null");
        Objects.requireNonNull(packages, "Packages to scan cannot be null");
        return this.scan(annotation.getName(), packages);
    }

    default public @NonNull Stream<Class<?>> scan(@NonNull Class<? extends Annotation> annotation, @NonNull Package pkg) {
        return this.scan(annotation.getName(), pkg.getName());
    }

    default public @NonNull Stream<Class<?>> scan(@NonNull String annotation, String ... packages) {
        Objects.requireNonNull(annotation, "Annotation type cannot be null");
        Objects.requireNonNull(packages, "Packages to scan cannot be null");
        Stream<String> stream = Arrays.stream(packages);
        return this.scan(annotation, stream);
    }

    default public @NonNull Stream<Class<?>> scan(@NonNull String annotation, @NonNull Collection<String> packages) {
        Objects.requireNonNull(annotation, "Annotation type cannot be null");
        Objects.requireNonNull(packages, "Packages to scan cannot be null");
        return this.scan(annotation, packages.parallelStream());
    }

    default public @NonNull Stream<Class<?>> scan(@NonNull Class<? extends Annotation> annotation, @NonNull Collection<String> packages) {
        Objects.requireNonNull(annotation, "Annotation type cannot be null");
        Objects.requireNonNull(packages, "Packages to scan cannot be null");
        return this.scan(annotation.getName(), packages.stream());
    }

    default public @NonNull Stream<Class<?>> scan(@NonNull String annotation, @NonNull Stream<String> packages) {
        Objects.requireNonNull(annotation, "Annotation type cannot be null");
        Objects.requireNonNull(packages, "Packages to scan cannot be null");
        return packages.flatMap(pkg -> this.scan(annotation, (String)pkg));
    }

    default public @NonNull Stream<Class<?>> scan(@NonNull Class<? extends Annotation> annotation, String ... packages) {
        Objects.requireNonNull(annotation, "Annotation type cannot be null");
        Objects.requireNonNull(packages, "Packages to scan cannot be null");
        return this.scan(annotation.getName(), packages);
    }
}

