/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.io.file;

import io.micronaut.core.io.ResourceLoader;
import io.micronaut.core.io.file.FileSystemResourceLoader;
import io.micronaut.core.util.SupplierUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class DefaultFileSystemResourceLoader
implements FileSystemResourceLoader {
    private final Supplier<BaseDir> baseDir;

    public DefaultFileSystemResourceLoader() {
        this.baseDir = SupplierUtil.memoized(BaseDir::new);
    }

    public DefaultFileSystemResourceLoader(File baseDirPath) {
        this(baseDirPath.toPath().normalize());
    }

    public DefaultFileSystemResourceLoader(String path) {
        this(Paths.get(DefaultFileSystemResourceLoader.normalize(path), new String[0]));
    }

    public DefaultFileSystemResourceLoader(Path path) {
        this.baseDir = SupplierUtil.memoized(() -> {
            try {
                Path baseDirPath = path.normalize().toRealPath(new LinkOption[0]);
                return new BaseDir(baseDirPath);
            }
            catch (IOException e) {
                return null;
            }
        });
    }

    @Override
    public Optional<InputStream> getResourceAsStream(String path) {
        Path filePath = this.getFilePath(DefaultFileSystemResourceLoader.normalize(path));
        if (this.isResolvableFile(filePath)) {
            try {
                return Optional.of(Files.newInputStream(filePath, new OpenOption[0]));
            }
            catch (IOException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<URL> getResource(String path) {
        Path filePath = this.getFilePath(DefaultFileSystemResourceLoader.normalize(path));
        if (this.isResolvableFile(filePath)) {
            try {
                URL url = filePath.toUri().toURL();
                return Optional.of(url);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    @Override
    public Stream<URL> getResources(String name) {
        return this.getResource(name).map(Stream::of).orElseGet(Stream::empty);
    }

    @Override
    public ResourceLoader forBase(String basePath) {
        return new DefaultFileSystemResourceLoader(basePath);
    }

    private boolean isResolvableFile(Path filePath) {
        return this.startsWithBase(filePath) && Files.exists(filePath, new LinkOption[0]) && Files.isReadable(filePath) && !Files.isDirectory(filePath, new LinkOption[0]);
    }

    private static String normalize(String path) {
        if (path == null) {
            return null;
        }
        if (path.startsWith("file:")) {
            path = path.substring(5);
        }
        return path;
    }

    private Path getFilePath(String path) {
        BaseDir base = this.baseDir.get();
        if (base != null) {
            return base.resolve(path);
        }
        return Paths.get(path, new String[0]);
    }

    private boolean startsWithBase(Path path) {
        BaseDir base = this.baseDir.get();
        if (base != null) {
            return base.startsWith(path);
        }
        return false;
    }

    private static final class BaseDir {
        final boolean exists;
        final Path dir;

        BaseDir() {
            this.exists = true;
            this.dir = null;
        }

        BaseDir(Path path) {
            Path baseDirPath;
            try {
                baseDirPath = path.normalize().toRealPath(new LinkOption[0]);
            }
            catch (IOException e) {
                baseDirPath = null;
            }
            this.exists = baseDirPath != null;
            this.dir = baseDirPath;
        }

        Path resolve(String path) {
            if (this.dir != null) {
                return this.dir.resolve(path);
            }
            return Paths.get(path, new String[0]);
        }

        boolean startsWith(Path path) {
            if (this.dir != null) {
                try {
                    Path relativePath = this.dir.resolve(path).toRealPath(new LinkOption[0]);
                    return relativePath.startsWith(this.dir);
                }
                catch (IOException e) {
                    return false;
                }
            }
            return this.exists;
        }
    }
}

