/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.io.buffer;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.NioReadBuffer;
import io.micronaut.core.io.buffer.ReadBuffer;
import io.micronaut.core.io.buffer.ReferenceCounted;
import io.micronaut.core.util.functional.ThrowingConsumer;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.util.Iterator;
import org.jspecify.annotations.NonNull;

public class ReadBufferFactory {
    private static final ReadBufferFactory INSTANCE = new ReadBufferFactory();

    @Internal
    protected ReadBufferFactory() {
    }

    public static @NonNull ReadBufferFactory getJdkFactory() {
        return INSTANCE;
    }

    public @NonNull ReadBuffer createEmpty() {
        return this.adapt(java.nio.ByteBuffer.allocate(0));
    }

    public @NonNull ReadBuffer copyOf(@NonNull CharSequence cs, @NonNull Charset charset) {
        return this.adapt(cs.toString().getBytes(charset));
    }

    public @NonNull ReadBuffer copyOf(@NonNull InputStream stream) throws IOException {
        return this.adapt(stream.readAllBytes());
    }

    public @NonNull ReadBuffer copyOf(@NonNull java.nio.ByteBuffer nioBuffer) {
        java.nio.ByteBuffer copy = java.nio.ByteBuffer.allocate(nioBuffer.remaining());
        copy.put(nioBuffer.slice());
        copy.flip();
        return this.adapt(copy);
    }

    public @NonNull ReadBuffer adapt(@NonNull java.nio.ByteBuffer nioBuffer) {
        return new NioReadBuffer(nioBuffer);
    }

    public @NonNull ReadBuffer adapt(@NonNull ByteBuffer<?> buffer) {
        byte[] byteArray = buffer.toByteArray();
        if (buffer instanceof ReferenceCounted) {
            ReferenceCounted rc = (ReferenceCounted)((Object)buffer);
            rc.release();
        }
        return this.adapt(byteArray);
    }

    public @NonNull ReadBuffer adapt(byte @NonNull [] array) {
        return this.adapt(java.nio.ByteBuffer.wrap(array));
    }

    public <T extends Throwable> @NonNull ReadBuffer buffer(@NonNull ThrowingConsumer<@NonNull ? super OutputStream, T> writer) throws T {
        NoCopyByteArrayOutputStream s = new NoCopyByteArrayOutputStream(32);
        writer.accept(s);
        return this.adapt(s.toByteBuffer());
    }

    public @NonNull BufferingOutputStream outputStreamBuffer() {
        return this.outputStreamBuffer(32);
    }

    private @NonNull BufferingOutputStream outputStreamBuffer(final int capacity) {
        return new BufferingOutputStream(){
            NoCopyByteArrayOutputStream out;
            final /* synthetic */ ReadBufferFactory this$0;
            {
                this.this$0 = this$0;
                this.out = new NoCopyByteArrayOutputStream(capacity);
            }

            @Override
            public OutputStream stream() {
                NoCopyByteArrayOutputStream out = this.out;
                if (out == null) {
                    throw new IllegalStateException("Already converted to buffer");
                }
                return out;
            }

            @Override
            public ReadBuffer finishBuffer() {
                NoCopyByteArrayOutputStream out = this.out;
                if (out == null) {
                    throw new IllegalStateException("Already converted to buffer");
                }
                this.out = null;
                return this.this$0.adapt(out.toByteBuffer());
            }

            @Override
            public void close() {
                this.out = null;
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public @NonNull ReadBuffer compose(@NonNull Iterable<@NonNull ReadBuffer> buffers) {
        try {
            int capacity = 0;
            for (ReadBuffer readBuffer : buffers) {
                capacity = Math.addExact(capacity, readBuffer.readable());
            }
            try (BufferingOutputStream bos = this.outputStreamBuffer(capacity);){
                for (ReadBuffer buffer : buffers) {
                    buffer.transferTo(bos.stream());
                }
                ReadBuffer readBuffer = bos.finishBuffer();
                return readBuffer;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        catch (Throwable e) {
            Iterator<ReadBuffer> iterator = buffers.iterator();
            while (iterator.hasNext()) {
                ReadBuffer readBuffer = iterator.next();
                try {
                    readBuffer.close();
                }
                catch (Throwable f) {
                    e.addSuppressed(f);
                }
            }
            throw e;
        }
    }

    private static final class NoCopyByteArrayOutputStream
    extends ByteArrayOutputStream {
        static final int DEFAULT_CAPACITY = 32;

        NoCopyByteArrayOutputStream(int capacity) {
            super(capacity);
        }

        java.nio.ByteBuffer toByteBuffer() {
            return java.nio.ByteBuffer.wrap(this.buf, 0, this.count);
        }
    }

    public static interface BufferingOutputStream
    extends Closeable {
        public @NonNull OutputStream stream() throws IllegalStateException;

        public @NonNull ReadBuffer finishBuffer() throws IOException, IllegalStateException;

        @Override
        public void close() throws IOException;
    }
}

