/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.io.buffer;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.io.buffer.ByteArrayByteBuffer;
import io.micronaut.core.io.buffer.ByteBuffer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.function.Function;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public abstract class ReadBuffer
implements AutoCloseable {
    @Internal
    protected ReadBuffer() {
    }

    public abstract int readable();

    public abstract @NonNull ReadBuffer duplicate();

    public abstract @NonNull ReadBuffer split(int var1) throws IndexOutOfBoundsException;

    public abstract @NonNull ReadBuffer move();

    public abstract void toArray(byte @NonNull [] var1, int var2) throws IndexOutOfBoundsException;

    public byte @NonNull [] toArray() {
        byte[] bytes = new byte[this.readable()];
        this.toArray(bytes, 0);
        return bytes;
    }

    public @NonNull String toString(Charset charset) {
        return new String(this.toArray(), charset);
    }

    public @NonNull ByteBuffer<?> toByteBuffer() {
        return new ByteArrayByteBuffer(this.toArray());
    }

    public @NonNull InputStream toInputStream() {
        return new ByteArrayInputStream(this.toArray());
    }

    public <R> @Nullable R useFastHeapBuffer(@NonNull Function<@NonNull java.nio.ByteBuffer, @NonNull R> function) {
        return null;
    }

    public void transferTo(@NonNull OutputStream stream) throws IOException {
        if (this.useFastHeapBuffer(bb -> {
            try {
                stream.write(bb.array(), bb.arrayOffset() + bb.position(), bb.remaining());
            }
            catch (IOException e) {
                ReadBuffer.sneakyThrow(e);
            }
            return true;
        }) == null) {
            stream.write(this.toArray());
        }
    }

    private static <T extends Throwable, R> R sneakyThrow(Throwable t) throws T {
        throw t;
    }

    @Override
    public abstract void close();

    protected abstract boolean isConsumed();

    protected abstract byte[] peekArray(int var1);

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        if (this.isConsumed()) {
            sb.append("[consumed]");
        } else {
            byte[] bytes;
            int readable = this.readable();
            sb.append("[len=").append(readable).append(", data='");
            for (byte b : bytes = this.peekArray(Math.min(readable, 32))) {
                if (b < 32 || b > 126) {
                    sb.append("\\x");
                    int i = b & 0xFF;
                    if (i < 16) {
                        sb.append('0');
                    }
                    sb.append(Integer.toHexString(i));
                    continue;
                }
                sb.append((char)b);
            }
            sb.append("'");
            if (readable > bytes.length) {
                sb.append('\u2026');
            }
            sb.append("]");
        }
        return sb.toString();
    }
}

